/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.plugin.api.deployment.ResolvedPlaceholder;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.service.deployment.AbstractChainGenerator;
import com.xebialabs.deployit.service.deployment.DeployedGenerator;
import com.xebialabs.deployit.service.deployment.DeployedPropertySetter;
import com.xebialabs.deployit.service.deployment.DeploymentContext;
import com.xebialabs.deployit.service.deployment.GeneratedDeployeds;
import com.xebialabs.deployit.service.deployment.ResolvedPlaceholderGenerator;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyResolverDeployedGenerator
extends AbstractChainGenerator {
    private static final Logger logger = LoggerFactory.getLogger(PropertyResolverDeployedGenerator.class);

    public PropertyResolverDeployedGenerator(DeployedGenerator processor) {
        super(processor);
    }

    @Override
    public GeneratedDeployeds generateDeployed(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        DeployedPropertySetter deployedPropertySetter = deploymentContext.getBeanSupplier().getBean(DeployedPropertySetter.class);
        GeneratedDeployeds generatedDeployeds = this.nextGenerator.generateDeployed(deploymentContext, deployable, container);
        generatedDeployeds.getDeployeds().forEach(deployed -> {
            ConsolidatedDictionary dictionary = deploymentContext.dictionaryFilteredByContainer(container);
            deployedPropertySetter.setProperties((EmbeddedDeployedContainer<?, ?>)deployed, (EmbeddedDeployedContainer<?, ?>)((EmbeddedDeployedContainer)deploymentContext.getExistingDeployedSupplier().getExistingDeployedWithContainer(deployable, container).orElse(null)), dictionary);
            String containerId = deployed.getContainer().getId();
            DeployedApplication deployedApplication = deploymentContext.getDeployedApplication();
            Set<ResolvedPlaceholder> resolvedPlaceholders = ResolvedPlaceholderGenerator.generate(deployedApplication, dictionary, containerId);
            deployedApplication.add$ResolvedPlaceholders(resolvedPlaceholders);
        });
        logger.debug("'{}' generated following deployeds [{}]", (Object)this.nextGenerator.getClass().getName(), (Object)generatedDeployeds);
        return generatedDeployeds;
    }
}

