package com.xebialabs.deployit.spring;

import com.xebialabs.deployit.deployment.planner.Planner;
import com.xebialabs.deployit.deployment.rules.PlanCreationContextFactory;
import com.xebialabs.deployit.deployment.rules.RuleBasedPlannerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DeploymentPlannerBeanBuilder {

    @Bean
    public Planner planner() {
        return ruleBasedPlannerFactory().planner();
    }

    @Bean
    public PlanCreationContextFactory planCreationContextFactory() {
        return ruleBasedPlannerFactory().planerCreationContextFactory();
    }

    @Bean
    public RuleBasedPlannerFactory ruleBasedPlannerFactory() {
        return new RuleBasedPlannerFactory();
    }
}
