/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.profile;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.model.XldUserProfile;
import com.xebialabs.deployit.security.repository.XldUserProfileRepository;
import com.xebialabs.deployit.security.sql.SqlUserService;
import com.xebialabs.deployit.service.profile.LicenseLimitReachedException;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.service.LicenseService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Service;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@Service
@Autowired
@ScalaSignature(bytes="\u0006\u0005\u0005\ra\u0001B\u0006\r\u0001]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!Aa\u0006\u0001B\u0001B\u0003%q\u0006C\u00037\u0001\u0011\u0005q\u0007C\u0004>\u0001\t\u0007I\u0011\u0002 \t\r\u001d\u0003\u0001\u0015!\u0003@\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015\u0011\u0007\u0001\"\u0003d\u0011\u0015Y\u0007\u0001\"\u0003m\u0005UAF\u000eZ+tKJ\u0004&o\u001c4jY\u0016\u001cVM\u001d<jG\u0016T!!\u0004\b\u0002\u000fA\u0014xNZ5mK*\u0011q\u0002E\u0001\bg\u0016\u0014h/[2f\u0015\t\t\"#\u0001\u0005eKBdw._5u\u0015\t\u0019B#A\u0005yK\nL\u0017\r\\1cg*\tQ#A\u0002d_6\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\f\u0001\u0004\u001f7e+N,'\u000f\u0015:pM&dWMU3q_NLGo\u001c:z!\t\u0001S%D\u0001\"\u0015\t\u00113%\u0001\u0006sKB|7/\u001b;pefT!\u0001\n\t\u0002\u0011M,7-\u001e:jifL!AJ\u0011\u00031acG-V:feB\u0013xNZ5mKJ+\u0007o\\:ji>\u0014\u00180A\u0006vg\u0016\u00148+\u001a:wS\u000e,\u0007CA\u0015-\u001b\u0005Q#BA\u0016$\u0003\r\u0019\u0018\u000f\\\u0005\u0003[)\u0012abU9m+N,'oU3sm&\u001cW-\u0001\bmS\u000e,gn]3TKJ4\u0018nY3\u0011\u0005A\"T\"A\u0019\u000b\u0005=\u0011$BA\u001a\u0013\u0003\u001da\u0017nY3og\u0016L!!N\u0019\u0003\u001d1K7-\u001a8tKN+'O^5dK\u00061A(\u001b8jiz\"B\u0001\u000f\u001e<yA\u0011\u0011\bA\u0007\u0002\u0019!)a\u0004\u0002a\u0001?!)q\u0005\u0002a\u0001Q!)a\u0006\u0002a\u0001_\u00051An\\4hKJ,\u0012a\u0010\t\u0003\u0001\u0016k\u0011!\u0011\u0006\u0003\u0005\u000e\u000bQa\u001d7gi)T\u0011\u0001R\u0001\u0004_J<\u0017B\u0001$B\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013!\u0005:fO&\u001cH/\u001a:M_\u001eLg\u000eV5nKR\u0011!*\u0014\t\u00033-K!\u0001\u0014\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001d\u001e\u0001\raT\u0001\tkN,'O\\1nKB\u0011\u0001k\u0016\b\u0003#V\u0003\"A\u0015\u000e\u000e\u0003MS!\u0001\u0016\f\u0002\rq\u0012xn\u001c;?\u0013\t1&$\u0001\u0004Qe\u0016$WMZ\u0005\u00031f\u0013aa\u0015;sS:<'B\u0001,\u001b\u0003e\u0019'/Z1uK>\u0013X\u000b\u001d3bi\u0016,6/\u001a:Qe>4\u0017\u000e\\3\u0015\t)cf\f\u0019\u0005\u0006;\"\u0001\raT\u0001\tMVdGNT1nK\")q\f\u0003a\u0001\u001f\u0006)Q-\\1jY\")\u0011\r\u0003a\u0001\u001f\u0006AQo]3s\u001d\u0006lW-\u0001\u0004fcV\fGn\u001d\u000b\u0004I\u001eL\u0007CA\rf\u0013\t1'DA\u0004C_>dW-\u00198\t\u000b!L\u0001\u0019A(\u0002\tM$(/\r\u0005\u0006U&\u0001\raT\u0001\u0005gR\u0014('A\u0011iCNd\u0015nY3og\u0016$vn\u0011:fCR,g*Z<FqR,'O\\1m+N,'/F\u0001eQ\t\u0001a\u000e\u0005\u0002pi6\t\u0001O\u0003\u0002re\u0006Q1\u000f^3sK>$\u0018\u0010]3\u000b\u0005M\u001c\u0015aD:qe&twM\u001a:b[\u0016<xN]6\n\u0005U\u0004(aB*feZL7-\u001a\u0015\u0003\u0001]\u0004\"\u0001_@\u000e\u0003eT!A_>\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002}{\u00069a-Y2u_JL(B\u0001@s\u0003\u0015\u0011W-\u00198t\u0013\r\t\t!\u001f\u0002\n\u0003V$xn^5sK\u0012\u0004")
public class XldUserProfileService {
    private final XldUserProfileRepository xldUserProfileRepository;
    private final SqlUserService userService;
    private final LicenseService licenseService;
    private final Logger logger;

    private Logger logger() {
        return this.logger;
    }

    public void registerLoginTime(String username) {
        this.xldUserProfileRepository.updateLastActive(username, new Date());
    }

    public void createOrUpdateUserProfile(String fullName, String email, String userName) {
        try {
            this.userService.read(userName);
            this.logger().info("Unable to create profile for user [{}]. A local account exists.", (Object)userName);
            throw new BadCredentialsException(String.format("A local account exists for user %s", userName));
        }
        catch (NotFoundException notFoundException) {
            Option profile = this.xldUserProfileRepository.findOne(userName, this.xldUserProfileRepository.findOne$default$2());
            if (profile.isEmpty()) {
                if (!this.hasLicenseToCreateNewExternalUser()) {
                    this.logger().info("Maximum number of users allowed by license has been reached. Cannot create external user profile for user [{}]", (Object)userName);
                    throw new LicenseLimitReachedException(String.format("Maximum number of users allowed by license has been reached. Cannot create external user profile for user %s", userName));
                }
                XldUserProfile userProfile = new XldUserProfile(userName, true, Predef$.MODULE$.Set().empty(), fullName, email, true, new Date(), false);
                this.xldUserProfileRepository.createUserProfile(userProfile, true);
            } else {
                XldUserProfile existingProfile = (XldUserProfile)profile.get();
                if (!this.equals(existingProfile.email(), email) || !this.equals(existingProfile.fullName(), fullName)) {
                    this.xldUserProfileRepository.updateExternalUserProfile(fullName, email, new Date(), userName);
                } else {
                    this.xldUserProfileRepository.updateLastActive(userName, new Date());
                }
            }
            return;
        }
    }

    private boolean equals(String str1, String str2) {
        Option option = Option$.MODULE$.apply((Object)str1);
        Option option2 = Option$.MODULE$.apply((Object)str2);
        return !(option != null ? !option.equals(option2) : option2 != null);
    }

    private boolean hasLicenseToCreateNewExternalUser() {
        String maxNumberOfUsers = this.licenseService.getLicense().getStringValue(LicenseProperty.MAX_NUMBER_OF_USERS);
        if (maxNumberOfUsers != null) {
            int countUserWithLoginAllowed = this.xldUserProfileRepository.countUserWithLoginAllowed();
            return Integer.parseInt(maxNumberOfUsers) > countUserWithLoginAllowed;
        }
        return true;
    }

    public XldUserProfileService(XldUserProfileRepository xldUserProfileRepository, SqlUserService userService, LicenseService licenseService) {
        this.xldUserProfileRepository = xldUserProfileRepository;
        this.userService = userService;
        this.licenseService = licenseService;
        this.logger = LoggerFactory.getLogger(XldUserProfileService.class);
    }
}

