/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.listener.authentication;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.security.policy.UserProfileCreationPolicy;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u0005\u001d4Aa\u0002\u0005\u0001'!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007C\u0003>\u0001\u0011\u0005a\bC\u0004C\u0001\t\u0007I\u0011B\"\t\r)\u0003\u0001\u0015!\u0003E\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015!\u0006\u0001\"\u0003V\u0005\t\nU\u000f\u001e5f]RL7-\u0019;j_:\u001cVoY2fgN,e/\u001a8u\u0019&\u001cH/\u001a8fe*\u0011\u0011BC\u0001\u000fCV$\b.\u001a8uS\u000e\fG/[8o\u0015\tYA\"\u0001\u0005mSN$XM\\3s\u0015\tia\"\u0001\u0005eKBdw._5u\u0015\ty\u0001#A\u0005yK\nL\u0017\r\\1cg*\t\u0011#A\u0002d_6\u001c\u0001aE\u0002\u0001)q\u0001\"!\u0006\u000e\u000e\u0003YQ!a\u0006\r\u0002\t1\fgn\u001a\u0006\u00023\u0005!!.\u0019<b\u0013\tYbC\u0001\u0004PE*,7\r\u001e\t\u0004;\u00112S\"\u0001\u0010\u000b\u0005}\u0001\u0013aB2p]R,\u0007\u0010\u001e\u0006\u0003C\t\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002G\u0005\u0019qN]4\n\u0005\u0015r\"aE!qa2L7-\u0019;j_:d\u0015n\u001d;f]\u0016\u0014\bCA\u0014.\u001b\u0005A#BA\u0015+\u0003\u0015)g/\u001a8u\u0015\tI1F\u0003\u0002-A\u0005A1/Z2ve&$\u00180\u0003\u0002/Q\tQ\u0012)\u001e;iK:$\u0018nY1uS>t7+^2dKN\u001cXI^3oi\u0006YRo]3s!J|g-\u001b7f\u0007J,\u0017\r^5p]B{G.[2jKN\u00042!\r\u001b7\u001b\u0005\u0011$BA\u001a\u0019\u0003\u0011)H/\u001b7\n\u0005U\u0012$\u0001\u0002'jgR\u0004\"aN\u001e\u000e\u0003aR!!\u000f\u001e\u0002\rA|G.[2z\u0015\taC\"\u0003\u0002=q\tIRk]3s!J|g-\u001b7f\u0007J,\u0017\r^5p]B{G.[2z\u0003\u0019a\u0014N\\5u}Q\u0011q(\u0011\t\u0003\u0001\u0002i\u0011\u0001\u0003\u0005\u0006_\t\u0001\r\u0001M\u0001\u0007Y><w-\u001a:\u0016\u0003\u0011\u0003\"!\u0012%\u000e\u0003\u0019S!a\u0012\u0012\u0002\u000bMdg\r\u000e6\n\u0005%3%A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002%=t\u0017\t\u001d9mS\u000e\fG/[8o\u000bZ,g\u000e\u001e\u000b\u0003\u001bN\u0003\"AT)\u000e\u0003=S\u0011\u0001U\u0001\u0006g\u000e\fG.Y\u0005\u0003%>\u0013A!\u00168ji\")\u0011&\u0002a\u0001M\u0005\u0001c-\u001b8e\u0003B\u0004H.[2bE2,Wk]3s\u0007J,\u0017\r^5p]B{G.[2z)\t1\u0016\fE\u0002O/ZJ!\u0001W(\u0003\r=\u0003H/[8o\u0011\u0015Ia\u00011\u0001[!\tYf,D\u0001]\u0015\ti6&\u0001\u0003d_J,\u0017BA0]\u00059\tU\u000f\u001e5f]RL7-\u0019;j_:D#\u0001A1\u0011\u0005\t,W\"A2\u000b\u0005\u0011\u0004\u0013AC:uKJ,w\u000e^=qK&\u0011am\u0019\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class AuthenticationSuccessEventListener
implements ApplicationListener<AuthenticationSuccessEvent> {
    private final List<UserProfileCreationPolicy> userProfileCreationPolicies;
    private final Logger logger;

    public boolean supportsAsyncExecution() {
        return super.supportsAsyncExecution();
    }

    private Logger logger() {
        return this.logger;
    }

    public void onApplicationEvent(AuthenticationSuccessEvent event) {
        Authentication authentication = event.getAuthentication();
        if (authentication != null && Strings.isNotEmpty((String)authentication.getName())) {
            block10: {
                Authentication authFromContext = SecurityContextHolder.getContext().getAuthentication();
                try {
                    try {
                        boolean hasLoginPermission;
                        if (authFromContext == null) {
                            SecurityContextHolder.getContext().setAuthentication(authentication);
                        }
                        if (!(hasLoginPermission = SecurityServiceLocator.getPermissionEnforcer().hasPermission(authentication, new Permission[]{PlatformPermissions.LOGIN}))) {
                            throw new DisabledException("The user " + authentication.getName() + " or its group(s) do not have login permission");
                        }
                        Option<UserProfileCreationPolicy> creationPolicyOption = this.findApplicableUserCreationPolicy(authentication);
                        Option<UserProfileCreationPolicy> option = creationPolicyOption;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            UserProfileCreationPolicy creationPolicy = (UserProfileCreationPolicy)some.value();
                            creationPolicy.createProfile(authentication);
                            break block10;
                        }
                        if (None$.MODULE$.equals(option)) {
                            this.logger().info("No applicable user profile creation policy found for authentication: {}", (Object)authentication.getName());
                            break block10;
                        }
                        throw new MatchError(option);
                    }
                    catch (Exception e) {
                        this.logger().warn("An error occurred during authentication success event handling for user: {}, {}", (Object)authentication.getName(), (Object)e.getMessage());
                    }
                }
                finally {
                    SecurityContextHolder.getContext().setAuthentication(authFromContext);
                }
            }
            return;
        }
    }

    private Option<UserProfileCreationPolicy> findApplicableUserCreationPolicy(Authentication authentication) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.userProfileCreationPolicies).asScala().sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.order()), (Ordering)Ordering.Int$.MODULE$)).find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.policyApplies(authentication)));
    }

    public AuthenticationSuccessEventListener(List<UserProfileCreationPolicy> userProfileCreationPolicies) {
        this.userProfileCreationPolicies = userProfileCreationPolicies;
        this.logger = LoggerFactory.getLogger(AuthenticationSuccessEventListener.class);
    }
}

