package com.xebialabs.deployit.service.deployment;


import com.xebialabs.deployit.plugin.api.udm.Deployed;

import java.util.ArrayList;
import java.util.List;

import static java.util.Collections.unmodifiableList;
import static java.util.stream.Collectors.joining;

public final class GeneratedDeployeds {

    private final List<Deployed> deployeds;

    public GeneratedDeployeds() {
        this(new ArrayList<>());
    }

    private GeneratedDeployeds(List<Deployed> deployeds) {
        this.deployeds = deployeds;
    }

    public List<Deployed> getDeployeds() {
        return unmodifiableList(deployeds);
    }

    public void addDeployed(Deployed deployed) {
        deployeds.add(deployed);
    }

    public void merge(GeneratedDeployeds that) {
        this.deployeds.addAll(that.deployeds);
    }

    @Override
    public String toString() {
        return deployeds.stream().map(Deployed::getName).collect(joining(","));
    }
}
