package com.xebialabs.deployit.service.version

import com.xebialabs.deployit.plugin.api.udm.{Environment, Version}
import com.xebialabs.deployit.service.replacement.{ConsolidatedDictionary, Dictionaries}
import org.springframework.stereotype.Component

import scala.util.Try

@Component
class VersionService {
  def resolvePlaceHolder(property: String, source: Version, environment: Environment): (String, ConsolidatedDictionary) = {
    val dictionary = Dictionaries.of(environment).filterBy(source).consolidate
    (resolvePlaceHolder(property, source, environment, dictionary), dictionary)
  }

  def resolvePlaceHolder(property: String, source: Version, environment: Environment, consolidatedDictionary: ConsolidatedDictionary): String = {
    val descriptor = source.getType.getDescriptor.getPropertyDescriptor(property)
    Option(descriptor)
      .map(_.get(source))
      .map(v => Try(consolidatedDictionary.resolve(v, descriptor)).getOrElse(v))
      .map(x => x.toString)
      .orNull
  }
}
