/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.service.deployment.AbstractChainGenerator;
import com.xebialabs.deployit.service.deployment.DeployedGenerator;
import com.xebialabs.deployit.service.deployment.DeploymentContext;
import com.xebialabs.deployit.service.deployment.GeneratedDeployeds;
import com.xebialabs.deployit.service.deployment.TagMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TagMatchingDeployedGenerator
extends AbstractChainGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(TagMatchingDeployedGenerator.class);
    private final TagMatcher tagMatcher = new TagMatcher();
    private final DeployedGenerator processor;

    public TagMatchingDeployedGenerator(DeployedGenerator processor) {
        super(processor);
        this.processor = processor;
    }

    @Override
    public GeneratedDeployeds generateDeployed(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        if (this.tagMatcher.areMatching(deployable, container)) {
            return this.processor.generateDeployed(deploymentContext, deployable, container);
        }
        LOG.debug("Tags do NOT match for {} and {}", (Object)deployable.getId(), (Object)container.getId());
        return new GeneratedDeployeds();
    }
}

