/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.principaldata;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.DirContextOperations;

public class LdapDataHelper {
    private static final Logger logger = LoggerFactory.getLogger(LdapDataHelper.class);

    public static String readStringAttribute(String entryName, DirContextOperations data, String attribute) {
        if (data == null) {
            return null;
        }
        if (!data.attributeExists(attribute)) {
            logger.warn("LDAP entry for entry {} has no '{}' attribute", (Object)entryName, (Object)attribute);
        } else {
            try {
                return data.getStringAttribute(attribute);
            }
            catch (ClassCastException e) {
                logger.warn("'{}' attribute of LDAP entry for user {} should be a String", (Object)attribute, (Object)entryName);
            }
        }
        return null;
    }
}

