package com.xebialabs.deployit.task

import com.xebialabs.deployit.engine.api.task.{TaskCreationService => ITaskCreationService}
import com.xebialabs.deployit.engine.tasker._
import com.xebialabs.deployit.plugin.api.flow.Step
import com.xebialabs.deployit.repository.WorkDirContext
import com.xebialabs.deployit.spring.BeanWrapper
import com.xebialabs.xlplatform.settings.shared.TaskerSettings
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.security.core.Authentication
import org.springframework.stereotype.Component
import java.util

import ai.digital.deploy.tasker.common.{TaskMetadata, TaskType}

import scala.jdk.CollectionConverters._

@Component
class TaskCreationService @Autowired()(val taskEngine: BeanWrapper[TaskExecutionEngine], taskerSettings: TaskerSettings) extends ITaskCreationService {

  override def createWithStepBlock(owner: Authentication, description: String, steps: util.List[Step],
                                   metadata: util.Map[String, String]): String = {

    val taskSteps = steps.asScala.map(new TaskStep(_)).toList

    val spec = new TaskSpecification(
      description,
      owner,
      WorkDirContext.get(),
      BlockBuilders.steps(description, None, taskSteps).build(),
      null, false, true
    )
    spec.getMetadata.put(TaskMetadata.TASK_TYPE, TaskType.DEFAULT.name())
    spec.getMetadata.put("maxActiveTasks", taskerSettings.maxActiveTasks.toString)
    val metadataOrEmpty: util.Map[String, String] = Option(metadata).getOrElse(Map[String, String]().asJava)
    spec.getMetadata.putAll(metadataOrEmpty)
    spec.getListeners.add(new WorkdirCleanerTrigger(WorkDirContext.get()))

    taskEngine.get().register(spec)
  }
}
