/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.listener.authentication;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.security.SecurityServiceLocator;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.security.policy.UserProfileCreationPolicy;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@ScalaSignature(bytes="\u0006\u000554A\u0001C\u0005\u0001)!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007C\u0003?\u0001\u0011\u0005q\bC\u0003D\u0001\u0011\u0005C\tC\u0004L\u0001\t\u0007I\u0011\u0002'\t\rM\u0003\u0001\u0015!\u0003N\u0011\u0015!\u0006\u0001\"\u0011V\u0011\u0015Q\u0006\u0001\"\u0003\\\u0005\t\nU\u000f\u001e5f]RL7-\u0019;j_:\u001cVoY2fgN,e/\u001a8u\u0019&\u001cH/\u001a8fe*\u0011!bC\u0001\u000fCV$\b.\u001a8uS\u000e\fG/[8o\u0015\taQ\"\u0001\u0005mSN$XM\\3s\u0015\tqq\"\u0001\u0005eKBdw._5u\u0015\t\u0001\u0012#A\u0005yK\nL\u0017\r\\1cg*\t!#A\u0002d_6\u001c\u0001aE\u0002\u0001+u\u0001\"AF\u000e\u000e\u0003]Q!\u0001G\r\u0002\t1\fgn\u001a\u0006\u00025\u0005!!.\u0019<b\u0013\tarC\u0001\u0004PE*,7\r\u001e\t\u0004=\u0015:S\"A\u0010\u000b\u0005\u0001\n\u0013aB2p]R,\u0007\u0010\u001e\u0006\u0003E\r\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002I\u0005\u0019qN]4\n\u0005\u0019z\"aE!qa2L7-\u0019;j_:d\u0015n\u001d;f]\u0016\u0014\bC\u0001\u0015/\u001b\u0005I#B\u0001\u0016,\u0003\u0015)g/\u001a8u\u0015\tQAF\u0003\u0002.C\u0005A1/Z2ve&$\u00180\u0003\u00020S\tQ\u0012)\u001e;iK:$\u0018nY1uS>t7+^2dKN\u001cXI^3oi\u0006YRo]3s!J|g-\u001b7f\u0007J,\u0017\r^5p]B{G.[2jKN\u00042AM\u001b8\u001b\u0005\u0019$B\u0001\u001b\u001a\u0003\u0011)H/\u001b7\n\u0005Y\u001a$\u0001\u0002'jgR\u0004\"\u0001\u000f\u001f\u000e\u0003eR!AO\u001e\u0002\rA|G.[2z\u0015\tiS\"\u0003\u0002>s\tIRk]3s!J|g-\u001b7f\u0007J,\u0017\r^5p]B{G.[2z\u0003\u0019a\u0014N\\5u}Q\u0011\u0001I\u0011\t\u0003\u0003\u0002i\u0011!\u0003\u0005\u0006a\t\u0001\r!M\u0001\u0017gV\u0004\bo\u001c:ug\u0006\u001b\u0018P\\2Fq\u0016\u001cW\u000f^5p]R\tQ\t\u0005\u0002G\u00136\tqIC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQuIA\u0004C_>dW-\u00198\u0002\r1|wmZ3s+\u0005i\u0005C\u0001(R\u001b\u0005y%B\u0001)$\u0003\u0015\u0019HN\u001a\u001bk\u0013\t\u0011vJ\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003Iyg.\u00119qY&\u001c\u0017\r^5p]\u00163XM\u001c;\u0015\u0005YK\u0006C\u0001$X\u0013\tAvI\u0001\u0003V]&$\b\"\u0002\u0016\u0007\u0001\u00049\u0013\u0001\t4j]\u0012\f\u0005\u000f\u001d7jG\u0006\u0014G.Z+tKJ\u001c%/Z1uS>t\u0007k\u001c7jGf$\"\u0001X0\u0011\u0007\u0019kv'\u0003\u0002_\u000f\n1q\n\u001d;j_:DQAC\u0004A\u0002\u0001\u0004\"!\u00193\u000e\u0003\tT!a\u0019\u0017\u0002\t\r|'/Z\u0005\u0003K\n\u0014a\"Q;uQ\u0016tG/[2bi&|g\u000e\u000b\u0002\u0001OB\u0011\u0001n[\u0007\u0002S*\u0011!.I\u0001\u000bgR,'/Z8usB,\u0017B\u00017j\u0005%\u0019u.\u001c9p]\u0016tG\u000f")
public class AuthenticationSuccessEventListener
implements ApplicationListener<AuthenticationSuccessEvent> {
    private final List<UserProfileCreationPolicy> userProfileCreationPolicies;
    private final Logger logger;

    public boolean supportsAsyncExecution() {
        return false;
    }

    private Logger logger() {
        return this.logger;
    }

    public void onApplicationEvent(AuthenticationSuccessEvent event) {
        Authentication authentication = event.getAuthentication();
        if (authentication != null && Strings.isNotEmpty((String)authentication.getName())) {
            block10: {
                block9: {
                    Authentication authFromContext = SecurityContextHolder.getContext().getAuthentication();
                    try {
                        if (authFromContext == null) {
                            SecurityContextHolder.getContext().setAuthentication(authentication);
                        }
                        boolean hasLoginPermission = SecurityServiceLocator.getPermissionEnforcer().hasPermission(authentication, new Permission[]{PlatformPermissions.LOGIN});
                        if (authentication.getName().equals("_xl-deploy-config-admin_")) {
                            break block9;
                        }
                        if (!hasLoginPermission) {
                            this.logger().info("User [{}] do not have permission to login.Please contact your Deploy administrator for further assistance.", (Object)authentication.getName());
                            throw new DisabledException("You do not have permission to login.Please contact your Deploy administrator for further assistance.");
                        }
                        Option<UserProfileCreationPolicy> creationPolicyOption = this.findApplicableUserCreationPolicy(authentication);
                        Option<UserProfileCreationPolicy> option = creationPolicyOption;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            UserProfileCreationPolicy creationPolicy = (UserProfileCreationPolicy)some.value();
                            creationPolicy.createProfile(authentication);
                            break block10;
                        }
                        if (None$.MODULE$.equals(option)) {
                            this.logger().info("No applicable user profile creation policy found for authentication: {}", (Object)authentication.getName());
                            break block10;
                        }
                        throw new MatchError(option);
                    }
                    finally {
                        SecurityContextHolder.getContext().setAuthentication(authFromContext);
                    }
                }
                return;
            }
            return;
        }
    }

    private Option<UserProfileCreationPolicy> findApplicableUserCreationPolicy(Authentication authentication) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.userProfileCreationPolicies).asScala().sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.order()), (Ordering)Ordering.Int$.MODULE$)).find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.policyApplies(authentication)));
    }

    public AuthenticationSuccessEventListener(List<UserProfileCreationPolicy> userProfileCreationPolicies) {
        this.userProfileCreationPolicies = userProfileCreationPolicies;
        this.logger = LoggerFactory.getLogger(AuthenticationSuccessEventListener.class);
    }
}

