package com.xebialabs.deployit.service.importer;

import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.server.api.importer.*;
import com.xebialabs.deployit.service.importer.reader.ManifestReaderDriver;
import com.xebialabs.deployit.service.importer.reader.XmlManifestReader;

import java.io.File;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

public class XmlManifestDarImporter implements ListableImporter {

    private static final String DRIVER = "driver";

    private final RepositoryService repositoryService;

    public XmlManifestDarImporter(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Override
    public List<String> list(File directory) {
        return newArrayList(PackageScanner.scan(directory,PackageScanner::isXmlManifestPackage));
    }

    @Override
    public boolean canHandle(ImportSource source) {
        File file = source.getFile();
        return PackageScanner.isXmlManifestPackage(file);
    }

    @Override
    public PackageInfo preparePackage(ImportSource source, ImportingContext context) {
        ManifestReaderDriver manifestReaderDriver = new ManifestReaderDriver(source, new XmlManifestReader(source));
        context.setAttribute(DRIVER, manifestReaderDriver);
        return manifestReaderDriver.readPackageInfo(context);
    }

    @Override
    public ImportedPackage importEntities(PackageInfo packageInfo, ImportingContext context) {
        ManifestReaderDriver driver = context.getAttribute(DRIVER);
        ImportedPackage importedPackage = driver.readDeploymentPackage(packageInfo, context);
        driver.resolveReferences(repositoryService, context);
        return importedPackage;
    }

    @Override
    public void cleanUp(PackageInfo packageInfo, ImportingContext context) {
        ((ManifestReaderDriver) context.getAttribute(DRIVER)).cleanUp(packageInfo, context);
        context.setAttribute(DRIVER, null);
    }
}
