/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.replacement.ConsolidatedDictionary;
import com.xebialabs.deployit.service.replacement.Dictionaries;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DeploymentContext {
    private final DeployedApplication deployedApplication;
    private final Dictionaries dictionaries;
    private final BeanSupplier beanSupplier;
    private final DeployedTypeSupplier typeSupplier;
    private final ExistingDeployedSupplier existingDeployedSupplier;
    private final DeployedIdGenerator deployedIdGenerator;
    private final Map<String, ConsolidatedDictionary> containerDictionaryCache = new HashMap<String, ConsolidatedDictionary>();

    public DeploymentContext(DeployedApplication deployedApplication, Dictionaries dictionaries, BeanSupplier beanSupplier, DeployedTypeSupplier typeSupplier, ExistingDeployedSupplier existingDeployedSupplier) {
        this(deployedApplication, dictionaries, beanSupplier, typeSupplier, existingDeployedSupplier, IdGenerator::generateId);
    }

    public DeploymentContext(DeployedApplication deployedApplication, Dictionaries dictionaries, BeanSupplier beanSupplier, DeployedTypeSupplier typeSupplier, ExistingDeployedSupplier existingDeployedSupplier, DeployedIdGenerator deployedIdGenerator) {
        this.deployedApplication = deployedApplication;
        this.dictionaries = dictionaries;
        this.beanSupplier = beanSupplier;
        this.typeSupplier = typeSupplier;
        this.existingDeployedSupplier = existingDeployedSupplier;
        this.deployedIdGenerator = deployedIdGenerator;
    }

    public DeployedTypeSupplier getTypeSupplier() {
        return this.typeSupplier;
    }

    public Dictionaries getDictionaries() {
        return this.dictionaries;
    }

    public ConsolidatedDictionary dictionaryFilteredByContainer(Container container) {
        return this.containerDictionaryCache.computeIfAbsent(container.getId(), k -> this.dictionaries.filterBy(container).consolidate());
    }

    public ExistingDeployedSupplier getExistingDeployedSupplier() {
        return this.existingDeployedSupplier;
    }

    public BeanSupplier getBeanSupplier() {
        return this.beanSupplier;
    }

    public DeployedApplication getDeployedApplication() {
        return this.deployedApplication;
    }

    public DeployedIdGenerator getDeployedIdGenerator() {
        return this.deployedIdGenerator;
    }

    public static interface DeployedIdGenerator {
        public String generatedId(Container var1, Deployable var2);
    }

    public static interface BeanSupplier {
        public <T> T getBean(Class<T> var1);
    }

    public static interface DeployedTypeSupplier {
        public Type getType(Deployable var1, Container var2);
    }

    public static interface ExistingDeployedSupplier {
        public List<Deployed> getExistingDeployed(Deployable var1);

        default public Optional<Deployed> getExistingDeployedWithContainer(Deployable deployable, Container container) {
            List<Deployed> existingDeployeds = this.getExistingDeployed(deployable);
            return existingDeployeds == null ? Optional.empty() : existingDeployeds.stream().filter(d -> d.getContainer().equals(container)).findFirst();
        }
    }
}

