package com.xebialabs.deployit.security.principaldata;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.DirContextOperations;

/**
 * Utility class for handling LDAP data retrieval.
 * This class provides methods to read attributes from LDAP entries.
 */
public class LdapDataHelper {
    private static final Logger logger = LoggerFactory.getLogger(LdapDataHelper.class);

    /**
     * Reads a string attribute from an LDAP entry.
     *
     * @param entryName The name of the LDAP entry from which to read the attribute.
     * @param data      The DirContextOperations instance containing the LDAP data.
     * @param attribute The name of the attribute to read.
     * @return The value of the attribute as a String, or null if the attribute does not exist or cannot be cast to a String.
     */
    public static String readStringAttribute(String entryName, DirContextOperations data, String attribute) {
        if (data == null) {
            return null;
        }

        if (!data.attributeExists(attribute)) {
            logger.warn("LDAP entry for entry {} has no '{}' attribute", entryName, attribute);
        } else {
            try {
                return data.getStringAttribute(attribute);
            } catch (ClassCastException e) {
                logger.warn("'{}' attribute of LDAP entry for user {} should be a String", attribute, entryName);
            }
        }
        return null;
    }
}
