/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.principaldata;

import com.xebialabs.deployit.security.principaldata.LdapUserDataProvider;
import com.xebialabs.deployit.security.principaldata.PrincipalDataProvider;
import com.xebialabs.deployit.security.principaldata.PrincipalDataProviderImpl;
import com.xebialabs.deployit.security.principaldata.UserDataProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.stereotype.Service;

@Service
public class PrincipalDataProviderFactoryBean
implements FactoryBean<PrincipalDataProvider>,
ApplicationContextAware,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(PrincipalDataProviderFactoryBean.class);
    private ApplicationContext context;
    private PrincipalDataProvider provider;

    public void afterPropertiesSet() throws Exception {
        PrincipalDataProviderImpl principalDataProvider = new PrincipalDataProviderImpl();
        List<UserDataProvider> ldapUserDataProviderList = this.tryInitUserDataProviderFromSpringLdapProvider();
        if (!ldapUserDataProviderList.isEmpty()) {
            principalDataProvider.addUserProvider(ldapUserDataProviderList);
        }
        this.provider = principalDataProvider;
    }

    public PrincipalDataProvider getObject() throws Exception {
        return this.provider;
    }

    public Class<?> getObjectType() {
        return PrincipalDataProvider.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private List<UserDataProvider> tryInitUserDataProviderFromSpringLdapProvider() {
        Map ldapProviders = this.context.getBeansOfType(LdapAuthenticationProvider.class);
        ArrayList<UserDataProvider> ldapUserDataProviderList = new ArrayList<UserDataProvider>();
        if (!ldapProviders.isEmpty()) {
            try {
                logger.info("Found {} in spring context, initializing from LDAP", (Object)LdapAuthenticationProvider.class.getSimpleName());
                ldapProviders.forEach((name, ldapProvider) -> ldapUserDataProviderList.add(new LdapUserDataProvider((LdapAuthenticationProvider)ldapProvider)));
            }
            catch (Exception e) {
                logger.warn("Error initializing from {}", (Object)LdapAuthenticationProvider.class.getSimpleName(), (Object)e);
            }
        }
        return ldapUserDataProviderList;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }
}

