/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.service.deployment.AbstractChainGenerator;
import com.xebialabs.deployit.service.deployment.DeployedGenerator;
import com.xebialabs.deployit.service.deployment.DeploymentContext;
import com.xebialabs.deployit.service.deployment.GeneratedDeployeds;
import com.xebialabs.deployit.service.deployment.TagMatcher;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSameDeployableChainGenerator
extends AbstractChainGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateSameDeployableChainGenerator.class);

    public UpdateSameDeployableChainGenerator(DeployedGenerator processor) {
        super(processor);
    }

    @Override
    public GeneratedDeployeds generateDeployed(DeploymentContext deploymentContext, Deployable deployable, Container container) {
        TagMatcher tagMatcher = new TagMatcher();
        Optional<Deployed> optionalDeployed = deploymentContext.getExistingDeployedSupplier().getExistingDeployedWithContainer(deployable, container);
        if (optionalDeployed.isPresent()) {
            Deployed previousDeployed = optionalDeployed.get();
            if (deployable.getType().equals((Object)previousDeployed.getDeployable().getType()) && tagMatcher.areMatching(deployable, container)) {
                return this.nextGenerator.generateDeployed(deploymentContext, deployable, container);
            }
            LOG.debug("Deployed for {} is not generated. Reusing previous deployable and adding validation error", (Object)deployable.getId());
            GeneratedDeployeds generatedDeployeds1 = this.nextGenerator.generateDeployed(deploymentContext, previousDeployed.getDeployable(), container);
            generatedDeployeds1.getDeployeds().forEach(d -> d.get$validationMessages().add(new ValidationMessage(previousDeployed.getId(), "source", "The deployable for this deployed is missing from the package.")));
            return generatedDeployeds1;
        }
        return new GeneratedDeployeds();
    }
}

