/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.source;

import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.service.importer.source.FileSource;
import com.xebialabs.deployit.util.GuavaFiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamSource
implements ImportSource {
    private final String fileName;
    private final InputStream stream;
    private FileSource file;
    private final File tempDir;

    public InputStreamSource(String fileName, InputStream stream) {
        this.fileName = fileName;
        this.stream = stream;
        this.tempDir = Files.createTempDir();
    }

    public File getFile() {
        if (this.file == null) {
            this.streamToTempFile();
        }
        return this.file.getFile();
    }

    private void streamToTempFile() {
        try {
            String fileNameCopy = this.fileName;
            int slash = fileNameCopy.lastIndexOf(47);
            if (slash != -1 && slash != fileNameCopy.length() - 1) {
                fileNameCopy = fileNameCopy.substring(slash);
            }
            File tempFile = new File(this.tempDir, fileNameCopy);
            new ByteSource(){

                public InputStream openStream() throws IOException {
                    return InputStreamSource.this.stream;
                }
            }.copyTo(Files.asByteSink((File)tempFile, (FileWriteMode[])new FileWriteMode[0]));
            this.file = new FileSource(tempFile, true);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public void cleanUp() {
        if (this.file != null) {
            this.file.cleanUp();
        }
        GuavaFiles.deleteQuietly((File)this.tempDir);
    }

    public String toString() {
        return this.getClass().getName() + "[" + String.valueOf(this.file != null ? this.file : "no file on disk") + "]";
    }
}

