package com.xebialabs.deployit.config;

import ai.digital.configuration.central.deploy.ClientProperties;
import com.xebialabs.deployit.ServerConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

@Configuration
public class CookieConfig {

    @Autowired
    private ClientProperties clientProperties;

    @Bean
    public CookieSerializer cookieSerializer() {
        ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();

        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setCookieName("SESSION_XLD");
        serializer.setUseHttpOnlyCookie(true);
        if (!serverConfiguration.isSsl()) {
            serializer.setUseSecureCookie(clientProperties.secureCookieEnabled());
        }
        serializer.setSameSite(SameSiteHelper.getSameSiteValue(
                SameSiteHelper.getStringValue(
                        clientProperties.sameSiteCookie(), ClientProperties.DEFAULT_SAMESITE_COOKIE())).getAttributeValue());
        return serializer;
    }
}
