package com.xebialabs.deployit.service.controltask;

import com.xebialabs.deployit.engine.api.dto.Control;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.repository.WorkDir;
import org.springframework.security.core.Authentication;

public interface ControlTaskService {
    Control prepare(String controlName, String id);

    TaskSpecification createTaskSpec(WorkDir workDir,
                                     ConfigurationItem ci,
                                     String controlTaskName,
                                     Parameters params,
                                     Authentication owner);

    String create(Control control, Authentication owner, WorkDir workDir);

    void start(String taskId);

    default void createAndStart(String controlName, String id, Authentication owner, WorkDir workDir) {
        start(create(prepare(controlName, id), owner, workDir));
    }
}
