/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.principaldata;

import com.xebialabs.deployit.security.principaldata.PrincipalDataProvider;
import com.xebialabs.deployit.security.principaldata.UserData;
import com.xebialabs.deployit.security.principaldata.UserDataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.security.core.GrantedAuthority;

class PrincipalDataProviderImpl
implements PrincipalDataProvider {
    private final List<UserDataProvider> userProviders = new ArrayList<UserDataProvider>();

    public void addUserProvider(UserDataProvider provider) {
        this.userProviders.add(provider);
    }

    public void addUserProvider(List<UserDataProvider> providers) {
        this.userProviders.addAll(providers);
    }

    @Override
    public UserData getUserData(String username) {
        return this.userProviders.stream().filter(provider -> provider.getUserData(username) != UserData.NOT_FOUND).map(provider -> provider.getUserData(username)).findFirst().orElse(UserData.NOT_FOUND);
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities(String username) {
        return this.userProviders.stream().map(provider -> provider.getAuthorities(username)).filter(authorities -> !authorities.isEmpty()).findFirst().orElse(Collections.emptySet());
    }
}

