package com.xebialabs.deployit.service.profile


import org.slf4j.LoggerFactory.getLogger
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import com.xebialabs.deployit.security.repository.XldUserGroupRepository

@Service
@Autowired
class XldUserGroupService(xldUserGroupRepository: XldUserGroupRepository) {

  private val logger = getLogger(classOf[XldUserGroupService])

  /**
   * Returns list of groups assigned to the user
   */
  def findGroupsForUser(username: String): Set[String] = {
    xldUserGroupRepository.findGroupsForUser(username)
  }

  /**
   * Creates a new group with given name if does not exist
   */
  def createGroup(groupName: String): Unit = {
    xldUserGroupRepository.createGroup(groupName)
  }

  /**
   * Deletes a group with given name if exists
   */
  def deleteGroup(groupName: String): Unit = {
    xldUserGroupRepository.deleteGroup(groupName)
  }

  /**
   * Creates a new group if does not exist and assigns group membership to the supplied user
   */
  def addUserToGroup(username: String, groupName: String): Unit = {
    xldUserGroupRepository.addUserToGroup(username, groupName)
  }

  /**
   * Removes group membership for the supplied user
   */
  def removeUserFromGroup(username: String, groupName: String): Unit = {
    xldUserGroupRepository.removeUserFromGroup(username, groupName)
  }

  /**
   * Assigns or removes group membership for the user based on supplied groupNames
   */
  def updateGroupsMembershipForUser(username: String, groupNames: Set[String]): Unit = {
    xldUserGroupRepository.updateGroupsMembershipForUser(username, groupNames)
  }


}
