package com.xebialabs.deployit.service.profile

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util.concurrent.atomic.AtomicReference

object XldUserProfileServiceHolder {
  val userProfileService: AtomicReference[XldUserProfileService] = new AtomicReference[XldUserProfileService]()
  def getXldUserProfileService: XldUserProfileService = userProfileService.get()
}

@Component
class XldUserProfileServiceHolder {
  @Autowired
  def this(userProfileService: XldUserProfileService) = {
    this()
    XldUserProfileServiceHolder.userProfileService.set(userProfileService)
  }
}
