package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.SelectedDeployment;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskPreviewBlock;
import com.xebialabs.deployit.plugin.api.reflect.Type;

import java.util.Map;

public interface DeploymentTaskService {

    boolean isDeployed(String applicationId, String environmentId);

    Deployment prepareInitial(String versionId, String environmentId);

    Deployment prepareUpdate(String versionId, String deployedApplicationId);

    Deployment prepareAutoDeployeds(Deployment deployment);

    String createTask(Deployment deployment);

    Deployment validate(Deployment deployment);

    void startDeploymentTask(String taskId);

    Deployment prepareUndeploy(String deployedApplicationId);

    Deployment generateSelectedDeployeds(SelectedDeployment selectedDeployment);

    Deployment generateSingleDeployed(String deployableId, String containerId, Type deployedType, Deployment deployment);

    TaskPreviewBlock taskPreviewBlock (Deployment deployment);

    StepState taskPreviewBlock(Deployment deployment, String blockId, int stepNr);

    String rollback(String taskid);

    Map<String, String> effectiveDictionary (String environment, String applicationVersion, String application, String container);
}
