package com.xebialabs.deployit.core.config

import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.deployit.repository.RepositoryService
import com.xebialabs.deployit.service.deployment.DeployedPropertySetter
import com.xebialabs.deployit.service.deployment.setter.{DefaultPropertySetter, FallbackPropertySetter, PreviousBehaviourPropertySetter}
import org.springframework.beans.factory.annotation.Value
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class DeployedPropertySetterConfig {

  @Value("${server.mapping.override.deployed.fields.on.update.previous.behaviour:false}")
  var shouldUsePreviousBehaviour: Boolean = _

  @Bean
  def deployedPropertySetter(serverConfiguration: ServerConfiguration,
                             repositoryService: RepositoryService): DeployedPropertySetter = {
    val propertySetter = if (serverConfiguration.isServerMappingOverrideDeployedFieldsOnUpdate)
      new DefaultPropertySetter(repositoryService)
    else if (shouldUsePreviousBehaviour)
      new PreviousBehaviourPropertySetter(repositoryService)
    else
      new FallbackPropertySetter(repositoryService)
    new DeployedPropertySetter(propertySetter)
  }

}
