package com.xebialabs.deployit.security.policy

import com.xebialabs.deployit.security.authentication.PersonalAuthenticationToken
import org.springframework.security.core.Authentication
import org.springframework.stereotype.Component

@Component
class PATUserGroupMembershipCreationPolicy extends UserGroupMembershipCreationPolicy {

  override def order(): Int = 10

  override def policyApplies(authentication: Authentication): Boolean = {
    null != authentication &&  authentication.isInstanceOf[PersonalAuthenticationToken]
  }

  override def updateUserGroupMembership(authentication: Authentication): Unit = {
    // no-op
  }
}
