package com.xebialabs.deployit.service

import com.xebialabs.deployit.booter.local.CiRoots
import org.springframework.context.annotation.Lazy
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
@Lazy(false)
class ValidateAllowedRoots {
  val allowedRoots = Set("Applications", "Blueprints", "ProvisioningEnvironments", "Environments", "Infrastructure", "Configuration", "Providers")

  validateAllowedRoots()

  private def validateAllowedRoots(): Unit = {
    val validRoots = CiRoots.all().asScala.groupBy(allowedRoots)
    require(!validRoots.contains(false), s"Configuration item roots [${validRoots(false).mkString(", ")}] are not allowed")
  }
}
