package com.xebialabs.deployit.security.policy

import org.springframework.security.core.Authentication

trait UserProfileCreationPolicy {

  /** Order of iteration. */
  def order(): Int

  /**
   * Should this policy be used to create the UserProfile.
   *
   * @param authentication succeeded authentication
   * @return evaluation result
   */
  def policyApplies(authentication: Authentication): Boolean

  /**
   * Create a UserProfile if needed.
   * Throws a BadCredentialsException in case there is already an internal user with the same user name.
   *
   * @param authentication succeeded authentication
   * @return the created UserProfile
   */
  def createProfile(authentication: Authentication): Unit
}
