/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.controltask;

import ai.digital.deploy.task.status.queue.TaskPathStatusListener;
import ai.digital.deploy.tasker.common.TaskType;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.deployment.planner.ExecutablePlan;
import com.xebialabs.deployit.deployment.planner.PhasedPlan;
import com.xebialabs.deployit.deployment.planner.PlanPhase;
import com.xebialabs.deployit.deployment.planner.Plans$;
import com.xebialabs.deployit.deployment.planner.Satellites$;
import com.xebialabs.deployit.deployment.planner.SerialPlan;
import com.xebialabs.deployit.deployment.planner.StepPlan;
import com.xebialabs.deployit.engine.api.dto.Control;
import com.xebialabs.deployit.engine.spi.event.TaskCreatedEvent;
import com.xebialabs.deployit.engine.spi.event.TaskStartedEvent;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.OnTaskFailurePolicy;
import com.xebialabs.deployit.plugin.api.udm.OnTaskSuccessPolicy;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItemWithPolicies;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.service.controltask.ControlTaskService;
import com.xebialabs.deployit.service.controltask.InvalidControlException;
import com.xebialabs.deployit.service.externalproperties.ExternalPropertiesResolver;
import com.xebialabs.deployit.spring.BeanWrapper;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Component
@ScalaSignature(bytes="\u0006\u0005\tEb\u0001B\n\u0015\u0001}A\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\ti\u0001\u0011\t\u0011)A\u0005]!AQ\u0007\u0001BC\u0002\u0013\u0005a\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u00038\u0011!q\u0004A!b\u0001\n\u0003y\u0004\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u00119\u0003!Q1A\u0005\u0002=C\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\u0006)\u0002!\t!\u0016\u0005\u0006i\u0002!\t%\u001e\u0005\b\u0003?\u0001A\u0011IA\u0011\u0011\u001d\ti\t\u0001C!\u0003\u001fCq!!'\u0001\t\u0003\nY\n\u0003\u0005\u0002*\u0002!\t\u0001FAV\u0011!\t\t\u000f\u0001Q\u0005\n\u0005\r\b\u0002CA\u0000\u0001\u0001&IA!\u0001\t\u0011\t=\u0001\u0001)C\u0005\u0005#A\u0001Ba\u0004\u0001A\u0013%!\u0011\u0004\u0002\u0017\u0007>tGO]8m)\u0006\u001c8nU3sm&\u001cW-S7qY*\u0011QCF\u0001\fG>tGO]8mi\u0006\u001c8N\u0003\u0002\u00181\u000591/\u001a:wS\u000e,'BA\r\u001b\u0003!!W\r\u001d7ps&$(BA\u000e\u001d\u0003%AXMY5bY\u0006\u00147OC\u0001\u001e\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0001\u0005\u000b\t\u0003C\u0019j\u0011A\t\u0006\u0003G\u0011\nA\u0001\\1oO*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014#\u0005\u0019y%M[3diB\u0011\u0011FK\u0007\u0002)%\u00111\u0006\u0006\u0002\u0013\u0007>tGO]8m)\u0006\u001c8nU3sm&\u001cW-A\tsKB|7/\u001b;pef\u001cVM\u001d<jG\u0016,\u0012A\f\t\u0003_Ij\u0011\u0001\r\u0006\u0003ca\t!B]3q_NLGo\u001c:z\u0013\t\u0019\u0004GA\tSKB|7/\u001b;pef\u001cVM\u001d<jG\u0016\f!C]3q_NLGo\u001c:z'\u0016\u0014h/[2fA\u0005QR\r\u001f;fe:\fG\u000e\u0015:pa\u0016\u0014H/[3t%\u0016\u001cx\u000e\u001c<feV\tq\u0007\u0005\u00029w5\t\u0011H\u0003\u0002;-\u0005\u0011R\r\u001f;fe:\fG\u000e\u001d:pa\u0016\u0014H/[3t\u0013\ta\u0014H\u0001\u000eFqR,'O\\1m!J|\u0007/\u001a:uS\u0016\u001c(+Z:pYZ,'/A\u000efqR,'O\\1m!J|\u0007/\u001a:uS\u0016\u001c(+Z:pYZ,'\u000fI\u0001\u0007K:<\u0017N\\3\u0016\u0003\u0001\u00032!\u0011#G\u001b\u0005\u0011%BA\"\u0019\u0003\u0019\u0019\bO]5oO&\u0011QI\u0011\u0002\f\u0005\u0016\fgn\u0016:baB,'\u000f\u0005\u0002H\u00176\t\u0001J\u0003\u0002J\u0015\u00061A/Y:lKJT!A\u0010\r\n\u00051C%a\u0005+bg.,\u00050Z2vi&|g.\u00128hS:,\u0017aB3oO&tW\rI\u0001\u000fo>\u00148\u000eR5s\r\u0006\u001cGo\u001c:z+\u0005\u0001\u0006CA\u0018R\u0013\t\u0011\u0006G\u0001\bX_J\\G)\u001b:GC\u000e$xN]=\u0002\u001f]|'o\u001b#je\u001a\u000b7\r^8ss\u0002\na\u0001P5oSRtD#\u0002,XOB\u0014\bCA\u0015\u0001\u0011\u0015a\u0013\u00021\u0001/Q\t9\u0016\f\u0005\u0002[K6\t1L\u0003\u0002];\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005y{\u0016a\u00024bGR|'/\u001f\u0006\u0003A\u0006\fQAY3b]NT!AY2\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001Z\u0001\u0004_J<\u0017B\u00014\\\u0005%\tU\u000f^8xSJ,G\rC\u00036\u0013\u0001\u0007q\u0007\u000b\u0002h3\"\"qM[7o!\tQ6.\u0003\u0002m7\nI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0002_\u0006qR\r\u001f;fe:\fG\u000e\u0015:pa\u0016\u0014H/[3t%\u0016\u001cx\u000e\u001c<fe&k\u0007\u000f\u001c\u0005\u0006}%\u0001\r\u0001\u0011\u0015\u0003afCQAT\u0005A\u0002AC#A]-\u0002\u000fA\u0014X\r]1sKR!aO`A\u000e!\t9H0D\u0001y\u0015\tI(0A\u0002ei>T!a\u001f&\u0002\u0007\u0005\u0004\u0018.\u0003\u0002~q\n91i\u001c8ue>d\u0007BB@\u000b\u0001\u0004\t\t!A\u0006d_:$(o\u001c7OC6,\u0007\u0003BA\u0002\u0003+qA!!\u0002\u0002\u0012A!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\fy\ta\u0001\u0010:p_Rt$BAA\b\u0003\u0015\u00198-\u00197b\u0013\u0011\t\u0019\"!\u0004\u0002\rA\u0013X\rZ3g\u0013\u0011\t9\"!\u0007\u0003\rM#(/\u001b8h\u0015\u0011\t\u0019\"!\u0004\t\u000f\u0005u!\u00021\u0001\u0002\u0002\u0005\u0011\u0011\u000eZ\u0001\u000fGJ,\u0017\r^3UCN\\7\u000b]3d)1\t\u0019#!\u000b\u00024\u0005%\u0013qNA=!\r9\u0015QE\u0005\u0004\u0003OA%!\u0005+bg.\u001c\u0006/Z2jM&\u001c\u0017\r^5p]\"9\u00111F\u0006A\u0002\u00055\u0012aB<pe.$\u0015N\u001d\t\u0004_\u0005=\u0012bAA\u0019a\t9qk\u001c:l\t&\u0014\bbBA\u001b\u0017\u0001\u0007\u0011qG\u0001\u0003G&\u0004B!!\u000f\u0002F5\u0011\u00111\b\u0006\u0005\u0003{\ty$A\u0002vI6T1a_A!\u0015\r\t\u0019\u0005G\u0001\u0007a2,x-\u001b8\n\t\u0005\u001d\u00131\b\u0002\u0012\u0007>tg-[4ve\u0006$\u0018n\u001c8Ji\u0016l\u0007bBA&\u0017\u0001\u0007\u0011QJ\u0001\u0010G>tGO]8m)\u0006\u001c8NT1nKB!\u0011qJA5\u001d\u0011\t\t&!\u001a\u000f\t\u0005M\u00131\r\b\u0005\u0003+\n\tG\u0004\u0003\u0002X\u0005}c\u0002BA-\u0003;rA!a\u0002\u0002\\%\tQ$\u0003\u0002\u001c9%\u0011\u0011DG\u0005\u0003}aI!!\u0013&\n\u0007\u0005\u001d\u0004*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0014Q\u000e\u0002\u0007)\u0006\u001c8.\u00133\u000b\u0007\u0005\u001d\u0004\nC\u0004\u0002r-\u0001\r!a\u001d\u0002\rA\f'/Y7t!\u0011\tI$!\u001e\n\t\u0005]\u00141\b\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c\bbBA>\u0017\u0001\u0007\u0011QP\u0001\u0006_^tWM\u001d\t\u0005\u0003\u007f\nI)\u0004\u0002\u0002\u0002*!\u00111QAC\u0003\u0011\u0019wN]3\u000b\u0007\u0005\u001d\u0015-\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\tY)!!\u0003\u001d\u0005+H\u000f[3oi&\u001c\u0017\r^5p]\u000611M]3bi\u0016$\u0002\"!\u0001\u0002\u0012\u0006U\u0015q\u0013\u0005\u0007\u0003'c\u0001\u0019\u0001<\u0002\u000f\r|g\u000e\u001e:pY\"9\u00111\u0010\u0007A\u0002\u0005u\u0004bBA\u0016\u0019\u0001\u0007\u0011QF\u0001\u0006gR\f'\u000f\u001e\u000b\u0005\u0003;\u000b)\u000b\u0005\u0003\u0002 \u0006\u0005VBAA\u0007\u0013\u0011\t\u0019+!\u0004\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003Ok\u0001\u0019AA\u0001\u0003\u0019!\u0018m]6JI\u0006\u0011\"-^5mI\u0016CXmY;uS>t\u0007\u000b\\1o)!\ti+!0\u0002@\u0006\u0005\u0007\u0003BAX\u0003sk!!!-\u000b\t\u0005M\u0016QW\u0001\ba2\fgN\\3s\u0015\r\t9\fG\u0001\u000bI\u0016\u0004Hn\\=nK:$\u0018\u0002BA^\u0003c\u0013a\"\u0012=fGV$\u0018M\u00197f!2\fg\u000eC\u0004\u000269\u0001\r!a\u000e\t\u000f\u0005-c\u00021\u0001\u0002\u0002!9\u00111\u0019\bA\u0002\u0005\u0015\u0017!B:uKB\u001c\bCBAd\u0003\u001f\f)N\u0004\u0003\u0002J\u00065g\u0002BA\u0004\u0003\u0017L!!a\u0004\n\t\u0005\u001d\u0014QB\u0005\u0005\u0003#\f\u0019N\u0001\u0003MSN$(\u0002BA4\u0003\u001b\u0001B!a6\u0002^6\u0011\u0011\u0011\u001c\u0006\u0005\u00037\fy$\u0001\u0003gY><\u0018\u0002BAp\u00033\u0014Aa\u0015;fa\u0006y1/\u0019;fY2LG/Z(g'R,\u0007\u000f\u0006\u0003\u0002f\u0006m\bCBAP\u0003O\fY/\u0003\u0003\u0002j\u00065!AB(qi&|g\u000e\u0005\u0003\u0002n\u0006]XBAAx\u0015\u0011\t\t0a=\u0002\u0013M\fG/\u001a7mSR,'bAA{5\u0005Q\u0001\u0010\u001c9mCR4wN]7\n\t\u0005e\u0018q\u001e\u0002\n'\u0006$X\r\u001c7ji\u0016Dq!!@\u0010\u0001\u0004\t).\u0001\u0003ti\u0016\u0004\u0018\u0001D1t!\"\f7/\u001a3QY\u0006tGC\u0002B\u0002\u0005\u0013\u0011Y\u0001\u0005\u0003\u00020\n\u0015\u0011\u0002\u0002B\u0004\u0003c\u0013!\u0002\u00155bg\u0016$\u0007\u000b\\1o\u0011\u001d\tY\u0005\u0005a\u0001\u0003\u0003AqA!\u0004\u0011\u0001\u0004\ti+\u0001\u0003qY\u0006t\u0017A\u00043fg\u000e\u0014\u0018\u000e\u001d;j_:4uN\u001d\u000b\t\u0003\u0003\u0011\u0019B!\u0006\u0003\u0018!9\u0011QG\tA\u0002\u0005]\u0002bBA&#\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003c\f\u0002\u0019AAs)\u0019\u0011YBa\b\u0003\"A\u0019\u0011E!\b\n\u0007\u0005]!\u0005C\u0004\u00026I\u0001\r!a\u000e\t\u000f\u0005-#\u00031\u0001\u0002\u0002!\u001a\u0001A!\n\u0011\t\t\u001d\"QF\u0007\u0003\u0005SQ1Aa\u000bb\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005_\u0011ICA\u0005D_6\u0004xN\\3oi\u0002")
public class ControlTaskServiceImpl
implements ControlTaskService {
    private final RepositoryService repositoryService;
    private final ExternalPropertiesResolver externalPropertiesResolver;
    private final BeanWrapper<TaskExecutionEngine> engine;
    private final WorkDirFactory workDirFactory;

    @Override
    public void createAndStart(String controlName, String id, Authentication owner, WorkDir workDir) {
        ControlTaskService.super.createAndStart(controlName, id, owner, workDir);
    }

    public RepositoryService repositoryService() {
        return this.repositoryService;
    }

    public ExternalPropertiesResolver externalPropertiesResolver() {
        return this.externalPropertiesResolver;
    }

    public BeanWrapper<TaskExecutionEngine> engine() {
        return this.engine;
    }

    public WorkDirFactory workDirFactory() {
        return this.workDirFactory;
    }

    @Override
    public Control prepare(String controlName, String id) {
        ConfigurationItem configurationItem = this.repositoryService().read(id);
        this.externalPropertiesResolver().resolveExternalProperties(new ConfigurationItem[]{configurationItem});
        MethodDescriptor controlTask = (MethodDescriptor)Option$.MODULE$.apply((Object)configurationItem.getType().getDescriptor().getControlTask(controlName)).getOrElse((Function0 & Serializable)() -> {
            throw new InvalidControlException("Control [%s] could  not be found on type [%s]", (scala.collection.immutable.Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{controlName, configurationItem.getType()}));
        });
        None$ params = controlTask.getParameterObjectType() != null ? Option$.MODULE$.apply((Object)controlTask.getParameterObjectType().getDescriptor().newInstance("parameters")) : None$.MODULE$;
        return new Control(configurationItem, controlName, (Parameters)params.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Override
    public TaskSpecification createTaskSpec(WorkDir workDir, ConfigurationItem ci, String controlTaskName, Parameters params, Authentication owner) {
        Tuple2 tuple2;
        MethodDescriptor method = DescriptorRegistry.getDescriptor((Type)ci.getType()).getControlTask(controlTaskName);
        Checks.checkArgument((method != null ? 1 : 0) != 0, (String)"ConfigurationItem %s of type %s does not have a control task named %s.", (Object[])new Object[]{ci.getId(), ci.getType(), controlTaskName});
        java.util.List steps = (java.util.List)method.invoke(ci, params);
        ConfigurationItem configurationItem = ci;
        if (configurationItem instanceof BaseConfigurationItemWithPolicies) {
            BaseConfigurationItemWithPolicies baseConfigurationItemWithPolicies = (BaseConfigurationItemWithPolicies)configurationItem;
            v0 = new Tuple2((Object)baseConfigurationItemWithPolicies.getOnSuccessPolicy(), (Object)baseConfigurationItemWithPolicies.getOnFailurePolicy());
        } else {
            v0 = tuple2 = new Tuple2((Object)OnTaskSuccessPolicy.NOOP, (Object)OnTaskFailurePolicy.NOOP);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        OnTaskSuccessPolicy onSuccessPolicy = (OnTaskSuccessPolicy)tuple2._1();
        OnTaskFailurePolicy onFailurePolicy = (OnTaskFailurePolicy)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)onSuccessPolicy, (Object)onFailurePolicy);
        OnTaskSuccessPolicy onSuccessPolicy2 = (OnTaskSuccessPolicy)tuple22._1();
        OnTaskFailurePolicy onFailurePolicy2 = (OnTaskFailurePolicy)tuple22._2();
        String desc = this.descriptionFor(ci, controlTaskName);
        PhasedPlan plan = this.asPhasedPlan(controlTaskName, this.buildExecutionPlan(ci, controlTaskName, (List<Step>)CollectionConverters$.MODULE$.ListHasAsScala(steps).asScala().toList()));
        PhasedPlan planForSatellites = Satellites$.MODULE$.prepareForSatelliteExecution(plan);
        PhaseContainer phaseContainer = Plans$.MODULE$.toBlockBuilder(planForSatellites).build();
        TaskSpecification taskSpec = new TaskSpecification(desc, owner, workDir, phaseContainer, onSuccessPolicy2, onFailurePolicy2);
        taskSpec.getListeners().add(new WorkdirCleanerTrigger(workDir));
        taskSpec.getListeners().add(new TaskPathStatusListener());
        ConfigurationItem currentCi = this.repositoryService().read(ci.getId());
        taskSpec.getMetadata().putAll(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskType"), (Object)TaskType.CONTROL.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskName"), (Object)controlTaskName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"taskLabel"), (Object)method.getLabel()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controlTaskTargetCI"), (Object)ci.getId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controlTaskTargetInternalCI"), (Object)currentCi.get$internalId().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controlTaskTargetSecureCI"), Option$.MODULE$.apply((Object)currentCi.get$securedCi()).map((Function1 & Serializable)x$2 -> x$2.toString()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"controlTaskTargetDirectoryRef"), (Object)currentCi.get$securedDirectoryReference())}))).asJava());
        return taskSpec;
    }

    @Override
    public String create(Control control, Authentication owner, WorkDir workDir) {
        ConfigurationItem ci = control.getConfigurationItem();
        String controlTaskName = control.getControlName();
        Parameters params = control.getParameters();
        TaskSpecification taskSpec = this.createTaskSpec(workDir, ci, controlTaskName, params, owner);
        String taskId = ((TaskExecutionEngine)this.engine().get()).register(taskSpec);
        EventBusHolder.publish((Object)new TaskCreatedEvent(taskId, controlTaskName, ci.getId()));
        return taskId;
    }

    @Override
    public void start(String taskId) {
        ((TaskExecutionEngine)this.engine().get()).execute(taskId);
        EventBusHolder.publish((Object)new TaskStartedEvent(taskId));
    }

    public ExecutablePlan buildExecutionPlan(ConfigurationItem ci, String controlTaskName, List<Step> steps) {
        List<Step> list = steps;
        if (Nil$.MODULE$.equals(list)) {
            throw new IllegalStateException("Control task " + controlTaskName + " on " + ci.getId() + " resulted in no steps.");
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Step head = (Step)colon2.head();
            Tuple2 tuple2 = new Tuple2(this.satelliteOfStep(head), ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Step[]{head})));
            List aggregator = Nil$.MODULE$.$colon$colon((Object)tuple2);
            List folded = (List)steps.drop(1).foldLeft((Object)aggregator, (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    List acc = (List)tuple2._1();
                    Step step = (Step)tuple2._2();
                    Object object = ((Tuple2)acc.headOption().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))._1();
                    Option<Satellite> option = this.satelliteOfStep(step);
                    if (!(object != null ? !object.equals(option) : option != null)) {
                        ((Buffer)((Tuple2)acc.headOption().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))._2()).append((Object)step);
                        return acc;
                    }
                }
                if (tuple2 != null) {
                    List acc = (List)tuple2._1();
                    Step step = (Step)tuple2._2();
                    Tuple2 tuple22 = new Tuple2(this.satelliteOfStep(step), ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Step[]{step})));
                    return acc.$colon$colon((Object)tuple22);
                }
                throw new MatchError((Object)tuple2);
            });
            List builders = folded.map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    Option sat = (Option)tuple2._1();
                    ArrayBuffer ss = (ArrayBuffer)tuple2._2();
                    return new StepPlan(this.descriptionFor(ci, controlTaskName, (Option<Satellite>)sat), (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ss.toList()).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava(), (Satellite)sat.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                }
                throw new MatchError((Object)tuple2);
            }).reverse();
            List list2 = builders;
            if (list2 instanceof .colon.colon) {
                .colon.colon colon3 = (.colon.colon)list2;
                StepPlan hd = (StepPlan)colon3.head();
                List list3 = colon3.next$access$1();
                if (Nil$.MODULE$.equals(list3)) {
                    return hd;
                }
            }
            return new SerialPlan(this.descriptionFor(ci, controlTaskName), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)list2).asJava(), null);
        }
        throw new MatchError(list);
    }

    private Option<Satellite> satelliteOfStep(Step step) {
        return Option$.MODULE$.apply((Object)step).collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Step, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                SatelliteAware satelliteAware;
                A1 A1 = x1;
                if (A1 instanceof SatelliteAware && (satelliteAware = (SatelliteAware)A1).getSatellite() != null) {
                    return (B1)satelliteAware.getSatellite();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Step x1) {
                SatelliteAware satelliteAware;
                Step step = x1;
                return step instanceof SatelliteAware && (satelliteAware = (SatelliteAware)step).getSatellite() != null;
            }
        });
    }

    private PhasedPlan asPhasedPlan(String controlTaskName, ExecutablePlan plan) {
        PlanPhase phase = new PlanPhase(plan, "Execute the " + controlTaskName + " control task", CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava(), false);
        return new PhasedPlan(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)phase, (List)Nil$.MODULE$)).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava());
    }

    private String descriptionFor(ConfigurationItem ci, String controlTaskName, Option<Satellite> satellite) {
        Option<Satellite> option = satellite;
        if (option instanceof Some) {
            Some some = (Some)option;
            Satellite x = (Satellite)some.value();
            return this.descriptionFor(ci, controlTaskName) + " (executed on " + x + ")";
        }
        if (None$.MODULE$.equals(option)) {
            return this.descriptionFor(ci, controlTaskName);
        }
        throw new MatchError(option);
    }

    private String descriptionFor(ConfigurationItem ci, String controlTaskName) {
        return "Control task [" + controlTaskName + "] for " + ci.getId();
    }

    public ControlTaskServiceImpl(@Autowired RepositoryService repositoryService, @Autowired @Qualifier(value="externalPropertiesResolverImpl") ExternalPropertiesResolver externalPropertiesResolver, @Autowired BeanWrapper<TaskExecutionEngine> engine, @Autowired WorkDirFactory workDirFactory) {
        this.repositoryService = repositoryService;
        this.externalPropertiesResolver = externalPropertiesResolver;
        this.engine = engine;
        this.workDirFactory = workDirFactory;
    }
}

