package com.xebialabs.deployit.service.dependency

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, DeployedApplication, DeploymentPackage, Version}
import com.xebialabs.deployit.repository.SearchParameters

import scala.collection.mutable.ListBuffer
import scala.jdk.CollectionConverters._

trait DeployedApplicationInfoLoader extends RepositoryServiceAware {

  def loadDeployedApplications(envId: String): List[DeployedApplicationInfo] = {
    val deployedApplications = repositoryService.listEntities(
      new SearchParameters().setParent(envId).setType(Type.valueOf("udm.DeployedApplication")), 1, false
    ).asScala.toList.asInstanceOf[List[ConfigurationItem]]
    val versionIds = new ListBuffer[String]()
    deployedApplications.foreach {
      case app: DeployedApplication => versionIds += app.getVersion.getId
    }

    val deploymentPackages = repositoryService.read(versionIds.toList.asJava, 1, true,
      true, true).asScala.toList.asInstanceOf[List[Version]]

    def getApplicationId(versionPackage: Version): String = if (versionPackage != null & versionPackage.toString.contains("/")) {
      versionPackage.toString.substring(0, versionPackage.toString.lastIndexOf('/'))
    } else {
      versionPackage.getId
    }
    def getDependencies(deploymentPackage: Version): Map[String, String] = deploymentPackage match {
      case dp: DeploymentPackage =>
        dp.getApplicationDependencies.asScala.toMap
      case _ => Map.empty[String, String]
    }
    deployedApplications.map {
      case app: DeployedApplication =>
        val deployedApplicationId = app.getId
        val depPackage = deploymentPackages.find(p => p.getId == app.getVersion.getId).getOrElse(app.getVersion)
        DeployedApplicationInfo(
          getApplicationId(depPackage),
          deployedApplicationId,
          app.getVersion.getId,
          getDependencies(depPackage))
    }
  }
}

case class DeployedApplicationInfo(applicationId: String, deployedApplicationId: String, versionId: String,
                                   applicationDependencies: Map[String, String])
