package com.xebialabs.deployit.service.gc;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

import javax.jcr.Repository;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.task.Task;

@SuppressWarnings("serial")
public class GarbageCollectionTask extends Task {

	private transient static AtomicBoolean gcInProgress = new AtomicBoolean(false);

	@SuppressWarnings("unchecked")
	public GarbageCollectionTask(Repository repository) {
		super((List<? extends Step<?>>) Lists.newArrayList(new GarbageCollectionStep(repository, gcInProgress)));
	}

	@Override
	public void processAfterRecovery() {
		super.processAfterRecovery();
		gcInProgress = new AtomicBoolean(false);
	}

	@Override
	public void doAfterTaskStateChangedToDone() {
		gcInProgress.set(false);
	}

	@Override
	public void doAfterTaskStateChangedToAborted() {
		gcInProgress.set(false);
	}

	public static boolean isInProgress() {
		return gcInProgress.get();
	}
}
