package com.xebialabs.deployit.service.validation;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;

import org.springframework.stereotype.Component;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;

@Component
public class Validator {

	public List<ValidationMessage> validate(ConfigurationItem roe, ConfigurationItem... cisInContext) {
	    return validate(roe, newArrayList(cisInContext));
    }

    public List<ValidationMessage> validate(ConfigurationItem ci, List<ConfigurationItem> cisInContext) {
        Type type = ci.getType();
        Descriptor descriptor = DescriptorRegistry.getDescriptor(type);
	    List<ValidationMessage> validate = descriptor.validate(ci);
	    return validate;
    }

}
