package com.xebialabs.deployit.spring;

import org.springframework.core.convert.converter.Converter;

import java.lang.reflect.Method;

public class MethodConverter implements Converter<String, Method> {
    @Override
    public Method convert(String source) {
        String[] split = source.split("#");
        Class<?> aClass = null;
        try {
            aClass = Class.forName(split[0]);
        } catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class [" + split[0] + "] does not exist");
        }
        Method[] methods = aClass.getMethods();
        for (Method method : methods) {
            if (method.getName().equals(split[1])) {
                return method;
            }
        }

        throw new IllegalArgumentException("Could not find method [" + split[1] + "] on class [" + split[0] + "]");
    }
}
