package com.xebialabs.deployit.task;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.execution.ExecutionContextListener;

public class ExecutionContextAttributes {

	private Map<String, Object> attributes;

	public ExecutionContextAttributes() {
		attributes = Maps.newHashMap();
	}

	public Map<String, Object> getAttributes() {
    	return attributes;
    }

	public Object getAttribute(String name) {
		return attributes.get(name);
	}

	public void setAttribute(String name, Object object) {
		attributes.put(name, object);
	}

	public void destroy() {
		for (Map.Entry<String, Object> each : attributes.entrySet()) {
			if (each.getValue() instanceof ExecutionContextListener) {
				try {
					logger.debug("Invoking StepExecutionContextListener on context attribute " + each.getKey());
					((ExecutionContextListener) each.getValue()).contextDestroyed();
				} catch (Exception exc) {
					logger.error("Could not destroy context attribute " + each.getKey(), exc);
				}
			}
		}
		attributes.clear();
	}

	private Logger logger = LoggerFactory.getLogger(ExecutionContextAttributes.class);

}
