package com.xebialabs.deployit.task;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;
import static com.google.common.collect.Lists.newArrayList;

class Registry {

	private ConcurrentMap<String, Task> reg = new ConcurrentHashMap<String, Task>();

	void register(Task task) {
		checkArgument(task.getId() != null, "task ID should have been set.");
		checkState(reg.putIfAbsent(task.getId(), task) == null);
	}

	public Task retrieve(String id) {
		return reg.get(id);
	}

	public void remove(String id) {
		reg.remove(id);
	}

	public Collection<Task> tasks() {
		return reg.values();
	}

	public void writeRecovery(ObjectOutputStream recoveryOut) throws IOException {
		Collection<Task> values = newArrayList(Collections2.filter(reg.values(), new Predicate<Task>() {
			public boolean apply(Task input) {
				return input instanceof DeploymentTask;
			}
		}));
		recoveryOut.writeObject(values);
	}

	public void recover(ObjectInputStream recoveryIn) throws IOException, ClassNotFoundException {
		Object o = recoveryIn.readObject();
		if (o instanceof Collection) {
			for (Task task : (Collection<Task>) o) {
				reg.put(task.getId(), task);
			}
		}
	}
}
