package com.xebialabs.deployit.security;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.atomic.AtomicReference;

@Component
public class SecurityServiceLocator {

	private static final AtomicReference<PermissionEnforcer> permissionEnforcer = new AtomicReference<PermissionEnforcer>();

	@Autowired
	public SecurityServiceLocator( PermissionEnforcer enforcer) {
		SecurityServiceLocator.permissionEnforcer.set(enforcer);
	}

	public static PermissionEnforcer getPermissionEnforcer() {
		return SecurityServiceLocator.permissionEnforcer.get();
	}
}
