package com.xebialabs.deployit.security;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.MDC;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class UsernameToMDCHandlerInterceptor implements HandlerInterceptor {

	private static final String MDC_KEY_USERNAME = "username";

	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
		SecurityContext context = SecurityContextHolder.getContext();
		Authentication creds = context.getAuthentication();
		if(creds != null) {
			MDC.put(MDC_KEY_USERNAME, creds.getName());
		}
		return true;
	}

	@Override
	public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
	}

	@Override
	public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
		MDC.remove(MDC_KEY_USERNAME);
	}

}
