package com.xebialabs.deployit.service.replacement;

import static com.xebialabs.deployit.service.replacement.MustachePlaceholders.newMustacheCompiler;

import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

import com.samskivert.mustache.MustacheException;
import com.xebialabs.deployit.service.deployment.DictionaryValueException;

public class MustachePlaceholderReplacer {

	public static final String IGNORE_PLACEHOLDER = "<ignore>";
	public static final String EMPTY_PLACEHOLDER = "<empty>";
	private final Map<String, ?> values;
	private final boolean interpretSpecialValues;

	public MustachePlaceholderReplacer(Map<String, ?> values) {
		this(values, true);
	}

	public MustachePlaceholderReplacer(Map<String, ?> values, final boolean interpretSpecialValues) {
		this.interpretSpecialValues = interpretSpecialValues;
		this.values = new ReplacerMap(values);
	}

	public String replace(String replaceable) throws DictionaryValueException {
		try {
			return newMustacheCompiler().compile(replaceable).execute(values);
		} catch (MustacheException me) {
			throw new DictionaryValueException(me, "Could not replace dictionary keys in %s", replaceable);
		}
	}

	public void replace(Reader in, Writer out) {
		newMustacheCompiler().compile(in).execute(values, out);
	}

	@SuppressWarnings("serial")
    private class ReplacerMap extends HashMap<String, Object> {
		public ReplacerMap(Map<String, ?> map) {
			super(map);
		}

		@Override
		public Object get(Object o) {
			Object s = super.get(o);
			if (interpretSpecialValues) {
				if (IGNORE_PLACEHOLDER.equals(s)) {
					return "{{" + o + "}}";
				} else if (EMPTY_PLACEHOLDER.equals(s)) {
					return "";
				}
			}
			return s;
		}
	}

}

