package com.xebialabs.deployit.util;

/**
 * Helper class to return two objects from a method.
 */
public class Tuple<A, B> {
	public final A a;
	public final B b;

	public Tuple(A a, B b) {
		this.a = a;
		this.b = b;
	}

	public A getA() {
		return a;
	}

	public B getB() {
		return b;
	}

	public static <A, B> Tuple<A, B> of(A a, B b) {
		return new Tuple<A, B>(a, b);
	}
	
	@Override
	public String toString() {
		return String.format("Tuple<%s, %s>", a, b);
	}
}
