package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.util.Tuple;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;

public class ChangeSet {

    private List<ConfigurationItem> createCis = newArrayList();
    private List<ConfigurationItem> updateCis = newArrayList();
    private List<String> deleteCiIds = newArrayList();
	private List<Tuple<ConfigurationItem, String>> moveCis = newArrayList();
	private List<Tuple<String, String>> renameCis = newArrayList();

	public List<ConfigurationItem> getCreateCis() {
        return createCis;
    }

    public void setCreateCis(List<ConfigurationItem> createCis) {
        this.createCis = createCis;
    }

    public List<ConfigurationItem> getUpdateCis() {
        return updateCis;
    }

    public void setUpdateCis(List<ConfigurationItem> updateCis) {
        this.updateCis = updateCis;
    }

	public void addUpdateCi(ConfigurationItem ci) {
		this.updateCis.add(ci);
	}

    public List<String> getDeleteCiIds() {
        return deleteCiIds;
    }

    public void setDeleteCiIds(List<String> deleteCiIds) {
        this.deleteCiIds = deleteCiIds;
    }

	public <T extends ConfigurationItem> void addMoveCi(T entity, String newId) {
		this.moveCis.add(new Tuple<ConfigurationItem, String>(entity, newId));
	}

	public List<Tuple<ConfigurationItem, String>> getMoveCis() {
		return moveCis;
	}

	public <T extends ConfigurationItem> void addRenameCi(String entity, String newName) {
		renameCis.add(new Tuple<String, String>(entity, newName));
	}

	public List<Tuple<String, String>> getRenameCis() {
		return renameCis;
	}
}
