package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import java.util.List;

/**
 * CRUDL for RepositoryEntity and things extending...
 */
public interface RepositoryService {

	boolean exists(String id);

	<T extends ConfigurationItem> T read(String id);

	<T extends ConfigurationItem> T read(String id, WorkDir workDir);

	<T extends ConfigurationItem> void create(T... entity);

	<T extends ConfigurationItem> void update(T... entity);

	<T extends ConfigurationItem> void move(T entity, String newId);

	void rename(String id, String newName);

	void delete(String... id);

    void execute(ChangeSet changeset);

    void checkReferentialIntegrity(ChangeSet changeset) throws ItemInUseException, ItemAlreadyExistsException;

	List<ConfigurationItemData> list(SearchParameters criteria);

	<T extends ConfigurationItem> List<T> listEntities(SearchParameters parameters);

	<T extends ConfigurationItem> List<T> getVersionHistory(String id);

}
