/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.upgrade;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployit371GlobalToLocalPermissions
extends Upgrade {
    private static final List<String> TO_BE_CONVERTED = Lists.newArrayList((Object[])new String[]{Permission.TASK_SKIPSTEP.getPermissionName(), Permission.TASK_MOVESTEP.getPermissionName()});
    private static final Logger logger = LoggerFactory.getLogger(Deployit371GlobalToLocalPermissions.class);

    public boolean doUpgrade(RawRepository rawRepository) throws UpgradeException {
        logger.info("*** Starting Deployit 3.7.1 upgrade -- Global to Local permissions ***");
        Node node = rawRepository.read("/$configuration/security");
        try {
            Map<String, String> map = this.readGlobalPermissions(node);
            logger.debug("Found global permissions: {}", map);
            this.convertPermissions(rawRepository, map);
            this.writeNewGlobalPermissions(node, map);
        }
        catch (RepositoryException repositoryException) {
            throw new UpgradeException("Could not convert global to local permissions", new Object[]{repositoryException});
        }
        logger.info("*** Done Deployit 3.7.1 upgrade -- Global to Local permissions ***");
        return true;
    }

    private void convertPermissions(RawRepository rawRepository, Map<String, String> map) throws RepositoryException {
        Map map2 = Maps.filterKeys(map, (Predicate)new Predicate<String>(){

            public boolean apply(String string) {
                return TO_BE_CONVERTED.contains(string);
            }
        });
        logger.debug("Going to write these permissions under the local nodes: {}", (Object)map2);
        Node node = rawRepository.read(JcrPathHelper.getAbsolutePathFromId(Metadata.ConfigurationItemRoot.ENVIRONMENTS.getRootNodeName()));
        this.updateNode(node, map2);
        List list = rawRepository.findNodesByType(Type.valueOf(Directory.class));
        logger.debug("Found these directories {}", (Object)list);
        for (Node node2 : list) {
            this.updateNode(node2, map2);
        }
    }

    private void updateNode(Node node, Map<String, String> map) throws RepositoryException {
        if (node.hasProperty("securityPermissions") && Permission.TASK_MOVESTEP.isApplicableTo(JcrPathHelper.getIdFromAbsolutePath(node.getPath()))) {
            logger.debug("Writing new local permissions on node [{}]", (Object)node.getPath());
            Map<String, String> map2 = JcrUtils.readMap(node.getProperty("securityPermissions"));
            logger.debug("read permissions {}", map2);
            for (String string : map.keySet()) {
                if (map2.containsKey(string)) {
                    map2.put(string, Joiner.on((String)",").join((Object)map2.get(string), (Object)map.get(string), new Object[0]));
                    continue;
                }
                map2.put(string, map.get(string));
            }
            logger.debug("Going to write permissions {}", map2);
            JcrUtils.writeMap(node, "securityPermissions", map2);
        }
    }

    private void writeNewGlobalPermissions(Node node, Map<String, String> map) throws RepositoryException {
        Map map2 = Maps.filterKeys(map, (Predicate)new Predicate<String>(){

            public boolean apply(String string) {
                return !TO_BE_CONVERTED.contains(string);
            }
        });
        JcrUtils.writeMap(node, "securityPermissions", map2);
    }

    private Map<String, String> readGlobalPermissions(Node node) throws RepositoryException {
        Property property = node.getProperty("securityPermissions");
        return JcrUtils.readMap(property);
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"deployit", (String)"3.7.1");
    }
}

