/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.upgrade;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployit371PolicyClear
extends Upgrade {
    private static final Logger logger = LoggerFactory.getLogger(Deployit371PolicyClear.class);

    public boolean doUpgrade(RawRepository rawRepository) throws UpgradeException {
        logger.info("*** Running Deployit 3.7.1 upgrade -- Remove policies blocking deletion ***");
        try {
            AccessControlManager accessControlManager = Deployit371PolicyClear.getAccessControlManager(rawRepository);
            Collection collection = DescriptorRegistry.getSubtypes((Type)Type.valueOf(ConfigurationItem.class));
            for (Type type : collection) {
                List list = rawRepository.findNodesByType(type);
                for (Node node : list) {
                    AccessControlPolicy[] accessControlPolicyArray = accessControlManager.getPolicies(node.getPath());
                    if (accessControlPolicyArray.length <= 0) continue;
                    logger.info("Node [{}] has unwanted policies, cleaning them", (Object)node.getPath());
                    this.clearPolicies(node, accessControlManager);
                }
            }
            logger.info("*** Finished Deployit 3.7.1 upgrade ***");
            return true;
        }
        catch (RepositoryException repositoryException) {
            throw new UpgradeException("", new Object[]{repositoryException});
        }
    }

    private void clearPolicies(Node node, AccessControlManager accessControlManager) throws RepositoryException {
        AccessControlPolicy[] accessControlPolicyArray;
        for (AccessControlPolicy accessControlPolicy : accessControlPolicyArray = accessControlManager.getPolicies(node.getPath())) {
            accessControlManager.removePolicy(node.getPath(), accessControlPolicy);
        }
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"deployit", (String)"3.7.1");
    }

    private static AccessControlManager getAccessControlManager(RawRepository rawRepository) throws RepositoryException {
        Session session = ((RawRepositoryImpl)rawRepository).getSession();
        return session.getAccessControlManager();
    }
}

