/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderReplacer;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderReplacer;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.local.LocalFile;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;

public class DerivedArtifactFile {
    private static final Class<LocalFile> proxyClass = DerivedArtifactFile.createProxyClass();

    private static Class<LocalFile> createProxyClass() {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(LocalFile.class);
        proxyFactory.setUseCache(false);
        proxyFactory.setUseWriteReplace(false);
        return proxyFactory.createClass();
    }

    public static LocalFile create(DerivedArtifact derivedArtifact) {
        try {
            Constructor<LocalFile> constructor = proxyClass.getConstructor(LocalConnection.class, File.class);
            LocalFile localFile = constructor.newInstance(LocalConnection.getLocalConnection(), null);
            ((ProxyObject)localFile).setHandler(DerivedArtifactFile.getMethodHandler(derivedArtifact));
            return localFile;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to create a proxy.", exception);
        }
    }

    private static MethodHandler getMethodHandler(DerivedArtifact derivedArtifact) {
        return new DerivedFileHandler(derivedArtifact);
    }

    public static class DerivedFileHandler
    implements MethodHandler,
    Serializable {
        private DerivedArtifact artifact;

        public DerivedFileHandler(DerivedArtifact derivedArtifact) {
            this.artifact = derivedArtifact;
        }

        public Object invoke(Object object, Method method, Method method2, Object[] objectArray) throws Throwable {
            if (ProxyFactory.isProxyClass(this.artifact.getFile().getClass())) {
                Checks.checkArgument(this.artifact.getSourceArtifact() != null, "%s should have a source artifact.", this.artifact.getId());
                Checks.checkArgument(this.artifact.getSourceArtifact().getFile() != null, "Source artifact %s of %s should have a file set.", this.artifact.getId(), this.artifact.getSourceArtifact().getId());
                this.artifact.initFile(new PlaceholderReplacer(){

                    public void replace(Reader reader, Writer writer, Map<String, String> map) {
                        new MustachePlaceholderReplacer(map).replace(reader, writer);
                    }
                });
            }
            return method.invoke((Object)this.artifact.getFile(), objectArray);
        }
    }
}

