/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.WorkDir;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InMemoryRepositoryService
implements RepositoryService {
    private Map<String, ConfigurationItem> store = Maps.newHashMap();

    @Override
    public boolean exists(String string) {
        return this.store.containsKey(string);
    }

    @Override
    public <T extends ConfigurationItem> T read(String string) {
        return (T)this.store.get(string);
    }

    @Override
    public <T extends ConfigurationItem> T read(String string, WorkDir workDir) {
        return this.read(string);
    }

    @Override
    public <T extends ConfigurationItem> void create(T ... TArray) {
        this.checkThatEntitiesDoNotExist((ConfigurationItem[])TArray);
        this.storeEntities((ConfigurationItem[])TArray);
    }

    private void checkThatEntitiesDoNotExist(ConfigurationItem[] configurationItemArray) {
        for (ConfigurationItem configurationItem : configurationItemArray) {
            if (!this.store.containsKey(configurationItem.getId())) continue;
            throw new IllegalStateException("Entity " + configurationItem.getId() + " already exists and cannot be created twice.");
        }
    }

    private void storeEntities(ConfigurationItem[] configurationItemArray) {
        for (ConfigurationItem configurationItem : configurationItemArray) {
            this.store.put(configurationItem.getId(), configurationItem);
        }
    }

    @Override
    public <T extends ConfigurationItem> void update(T ... TArray) {
        for (T t : TArray) {
            if (this.store.containsKey(t.getId())) continue;
            throw new IllegalStateException("Cannot update nonexisting");
        }
        for (T t : TArray) {
            this.store.put(t.getId(), (ConfigurationItem)t);
        }
    }

    @Override
    public <T extends ConfigurationItem> void move(T t, String string) {
        this.store.remove(t.getId());
        t.setId(string);
        this.store.put(string, t);
    }

    @Override
    public void rename(String string, String string2) {
        ConfigurationItem configurationItem = this.store.remove(string);
        configurationItem.setId(string.substring(0, string.lastIndexOf(47) + 1) + string2);
        this.store.put(configurationItem.getId(), configurationItem);
    }

    @Override
    public void delete(String ... stringArray) {
        for (String string : stringArray) {
            this.store.remove(string);
        }
    }

    @Override
    public void execute(ChangeSet changeSet) {
        if (!changeSet.getCreateCis().isEmpty()) {
            this.create(changeSet.getCreateCis().toArray(new ConfigurationItem[changeSet.getCreateCis().size()]));
        }
        if (!changeSet.getUpdateCis().isEmpty()) {
            this.update(changeSet.getUpdateCis().toArray(new ConfigurationItem[changeSet.getUpdateCis().size()]));
        }
        if (!changeSet.getDeleteCiIds().isEmpty()) {
            this.delete(changeSet.getDeleteCiIds().toArray(new String[changeSet.getDeleteCiIds().size()]));
        }
    }

    @Override
    public List<ConfigurationItemData> list(SearchParameters searchParameters) {
        ArrayList arrayList = Lists.newArrayList();
        if (searchParameters.type != null) {
            for (ConfigurationItem configurationItem : this.store.values()) {
                if (!configurationItem.getType().equals((Object)searchParameters.type)) continue;
                arrayList.add(new ConfigurationItemData(configurationItem.getId(), configurationItem.getType()));
            }
            return arrayList;
        }
        throw new UnsupportedOperationException("Ask Jeroen");
    }

    @Override
    public <T extends ConfigurationItem> List<T> listEntities(SearchParameters searchParameters) {
        throw new UnsupportedOperationException("Ask Robert and Vincent");
    }

    @Override
    public void checkReferentialIntegrity(ChangeSet changeSet) throws ItemInUseException {
    }

    @Override
    public <T extends ConfigurationItem> List<T> getVersionHistory(String string) {
        throw new UnsupportedOperationException("Not implemented for " + this.getClass());
    }
}

