/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.io.DerivedArtifactFile;
import com.xebialabs.deployit.io.Exploder;
import com.xebialabs.deployit.io.FileWithoutContent;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.NodeReaderContext;
import com.xebialabs.deployit.repository.NodeUtils;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.SearchQueryBuilder;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.util.PasswordObfuscator;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeReader {
    private Session session;
    private Node node;
    private final WorkDir workDir;
    private NodeReaderContext context;
    private static final Logger logger = LoggerFactory.getLogger(NodeReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends ConfigurationItem> T read(Session session, Node node, WorkDir workDir) throws RepositoryException {
        NodeReaderContext nodeReaderContext = NodeReaderContext.get().hold();
        try {
            T t = new NodeReader(session, node, workDir, nodeReaderContext).read();
            return t;
        }
        finally {
            nodeReaderContext.release();
        }
    }

    private NodeReader(Session session, Node node, WorkDir workDir, NodeReaderContext nodeReaderContext) {
        this.session = session;
        this.node = node;
        this.workDir = workDir;
        this.context = nodeReaderContext;
    }

    private <T extends ConfigurationItem> T read() throws RepositoryException {
        String string = JcrPathHelper.getIdFromAbsolutePath(this.node.getPath());
        logger.trace("{} loading with workdir {}", (Object)string, (Object)this.workDir);
        if (this.context.hasItem(this.node.getIdentifier())) {
            ConfigurationItem configurationItem = this.context.get(this.node.getIdentifier());
            Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)configurationItem.getType());
            if (descriptor.isAssignableTo(SourceArtifact.class) && this.workDir != null && ((SourceArtifact)configurationItem).getFile() instanceof FileWithoutContent) {
                this.copyData(configurationItem, descriptor);
            } else if (descriptor.isAssignableTo(DerivedArtifact.class) && this.workDir != null && ((DerivedArtifact)configurationItem).getFile() == null) {
                this.copyData(configurationItem, descriptor);
            }
            return (T)configurationItem;
        }
        Type type = Type.valueOf((String)this.node.getProperty("$configuration.item.type").getString());
        if (!type.exists()) {
            logger.warn("While trying to read node [{}] its type [{}] was not found in any plugin. Please make sure the required plugin is installed.", (Object)this.node.getPath(), (Object)type);
            throw new RepositoryException(String.format("Unknown type [%s] while reading node [%s]", type, this.node.getPath()));
        }
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)type);
        ConfigurationItem configurationItem = descriptor.newInstance();
        configurationItem.setId(string);
        this.context.put(this.node.getIdentifier(), configurationItem);
        this.copyValues(configurationItem, descriptor);
        this.copyData(configurationItem, descriptor);
        return (T)configurationItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ConfigurationItem> void copyData(T t, Descriptor descriptor) throws RepositoryException {
        DerivedArtifact derivedArtifact;
        if (descriptor.isAssignableTo(SourceArtifact.class) && this.workDir != null) {
            LocalFile localFile;
            block16: {
                String string = this.node.getProperty("$filename").getString();
                localFile = this.workDir.newFile(string);
                Binary binary = this.node.getProperty("$data").getBinary();
                try {
                    logger.debug("Reading Source Artifact {} of type {} data. " + t.getId(), (Object)descriptor);
                    if (descriptor.isAssignableTo(FolderArtifact.class)) {
                        localFile.mkdir();
                        try {
                            Exploder.explode(this.createInputSupplier(binary), localFile.getFile());
                            break block16;
                        }
                        catch (IOException iOException) {
                            throw new RuntimeIOException("Could not extract data from " + t.getId() + " to directory " + localFile.getPath(), iOException);
                        }
                    }
                    OutputStream outputStream = localFile.getOutputStream();
                    try {
                        ByteStreams.copy(this.createInputSupplier(binary), (OutputStream)outputStream);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeIOException("Could not copy data from " + t.getId() + " to file " + localFile.getPath(), iOException);
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)outputStream);
                    }
                }
                finally {
                    binary.dispose();
                }
            }
            ((Artifact)t).setFile((OverthereFile)localFile);
        } else if (descriptor.isAssignableTo(SourceArtifact.class)) {
            String string = this.node.getProperty("$filename").getString();
            ((Artifact)t).setFile((OverthereFile)new FileWithoutContent(string));
        } else if (descriptor.isAssignableTo(DerivedArtifact.class) && this.workDir != null && (derivedArtifact = (DerivedArtifact)t).getSourceArtifact() != null) {
            derivedArtifact.setFile((OverthereFile)DerivedArtifactFile.create(derivedArtifact));
        }
    }

    private InputSupplier<InputStream> createInputSupplier(final Binary binary) {
        return new InputSupplier<InputStream>(){

            public InputStream getInput() throws IOException {
                try {
                    return binary.getStream();
                }
                catch (RepositoryException repositoryException) {
                    throw new IOException("Could not get inputstream from node.");
                }
            }
        };
    }

    private <T extends ConfigurationItem> void copyValues(T t, Descriptor descriptor) throws RepositoryException {
        for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            if (!this.node.hasProperty(propertyDescriptor.getName()) && !propertyDescriptor.isAsContainment()) {
                logger.trace("Repository node [{}] does not contain value for (non-containment) property [{}]. Using the default value.", (Object)t.getId(), (Object)propertyDescriptor);
                continue;
            }
            if (propertyDescriptor.isTransient()) {
                if (this.node.hasProperty(propertyDescriptor.getName())) {
                    logger.warn("Repository node [{}] contains transient property [{}] which should not have been persisted.", (Object)t.getId(), (Object)propertyDescriptor);
                }
                logger.trace("Not attempting to read transient property [{}] from repository node [{}]. Using the default value.", (Object)propertyDescriptor, (Object)t.getId());
                continue;
            }
            switch (propertyDescriptor.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    this.setPrimitiveProperty(t, propertyDescriptor);
                    break;
                }
                case SET_OF_STRING: {
                    propertyDescriptor.set(t, (Object)Sets.newHashSet(this.getCollectionOfStringValues(t, propertyDescriptor)));
                    break;
                }
                case SET_OF_CI: {
                    propertyDescriptor.set(t, (Object)Sets.newHashSet(this.getCollectionOfConfigurationItemValues(t, propertyDescriptor)));
                    break;
                }
                case LIST_OF_STRING: {
                    propertyDescriptor.set(t, (Object)Lists.newArrayList(this.getCollectionOfStringValues(t, propertyDescriptor)));
                    break;
                }
                case LIST_OF_CI: {
                    propertyDescriptor.set(t, (Object)Lists.newArrayList(this.getCollectionOfConfigurationItemValues(t, propertyDescriptor)));
                    break;
                }
                case CI: {
                    this.setConfigurationItemProperty(t, propertyDescriptor);
                    break;
                }
                case MAP_STRING_STRING: {
                    this.copyMapPropertyFromNode(t, propertyDescriptor);
                }
            }
        }
    }

    private <T extends ConfigurationItem> void copyMapPropertyFromNode(T t, PropertyDescriptor propertyDescriptor) throws RepositoryException {
        Property property = this.node.getProperty(propertyDescriptor.getName());
        propertyDescriptor.set(t, JcrUtils.readMap(property));
    }

    private <T extends ConfigurationItem> void setConfigurationItemProperty(T t, PropertyDescriptor propertyDescriptor) throws RepositoryException {
        Node node;
        if (propertyDescriptor.isAsContainment()) {
            node = this.node.getParent();
        } else {
            Value value = this.node.getProperty(propertyDescriptor.getName()).getValue();
            node = NodeUtils.getReferencedCiNode(this.node, value, this.session);
        }
        propertyDescriptor.set(t, NodeReader.read(this.session, node, this.workDir));
    }

    private <T extends ConfigurationItem> Collection<ConfigurationItem> getCollectionOfConfigurationItemValues(T t, PropertyDescriptor propertyDescriptor) throws RepositoryException, InvalidQueryException, ValueFormatException, PathNotFoundException {
        ArrayList arrayList = Lists.newArrayList();
        if (propertyDescriptor.isAsContainment()) {
            SearchParameters searchParameters = new SearchParameters().setParent(t.getId()).setType(propertyDescriptor.getReferencedType());
            SearchQueryBuilder searchQueryBuilder = new SearchQueryBuilder(searchParameters);
            Query query = searchQueryBuilder.build(this.session);
            QueryResult queryResult = query.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                arrayList.add(NodeReader.read(this.session, node, this.workDir));
            }
        } else {
            for (Value value : this.node.getProperty(propertyDescriptor.getName()).getValues()) {
                Node node = NodeUtils.getReferencedCiNode(this.node, value, this.session);
                arrayList.add(NodeReader.read(this.session, node, this.workDir));
            }
        }
        return arrayList;
    }

    private <T extends ConfigurationItem> Collection<String> getCollectionOfStringValues(T t, PropertyDescriptor propertyDescriptor) throws ValueFormatException, RepositoryException, PathNotFoundException {
        ArrayList arrayList = Lists.newArrayList();
        for (Value value : this.node.getProperty(propertyDescriptor.getName()).getValues()) {
            arrayList.add(value.getString());
        }
        return arrayList;
    }

    private <T extends ConfigurationItem> void setPrimitiveProperty(T t, PropertyDescriptor propertyDescriptor) throws RepositoryException {
        String string = this.node.getProperty(propertyDescriptor.getName()).getString();
        if (propertyDescriptor.getKind() == PropertyKind.STRING && propertyDescriptor.isPassword()) {
            string = PasswordObfuscator.ensureDecrypted(string);
        }
        propertyDescriptor.set(t, (Object)string);
    }
}

