/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.xebialabs.deployit.repository.JcrPathHelper;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.spi.commons.value.QValueValue;

public class NodeUtils {
    static Node getReferencedCiNode(Node node, Value value, Session session) throws RepositoryException {
        String string = ((QValueValue)value).getQValue().getString();
        return NodeUtils.getNodeByUuid(node, string, session);
    }

    static String getReferencedCiId(Node node, Value value, Session session) throws RepositoryException {
        return JcrPathHelper.getIdFromAbsolutePath(NodeUtils.getReferencedCiNode(node, value, session).getPath());
    }

    protected static Node getNodeByUuid(Node node, String string, Session session) throws RepositoryException {
        try {
            return session.getNodeByIdentifier(string);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            Node node2;
            if (NodeUtils.nodeIsFrozen(node) && (node2 = NodeUtils.getFrozenNodeByUuid(string, session)) != null) {
                return node2;
            }
            throw itemNotFoundException;
        }
    }

    static Node getFrozenNodeByUuid(String string, Session session) throws RepositoryException {
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        ValueFactory valueFactory = session.getValueFactory();
        Query query = queryManager.createQuery("SELECT * FROM [{http://www.jcp.org/jcr/nt/1.0}frozenNode] WHERE [jcr:frozenUuid] = $uuid", "JCR-SQL2");
        query.bindValue("uuid", valueFactory.createValue(string));
        QueryResult queryResult = query.execute();
        NodeIterator nodeIterator = queryResult.getNodes();
        if (nodeIterator.hasNext()) {
            return nodeIterator.nextNode();
        }
        return null;
    }

    static boolean nodeIsFrozen(Node node) throws RepositoryException {
        return node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}frozenNode");
    }
}

