/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.util.concurrent.Monitor;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalFile;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkDirFactory {
    @Autowired
    private String baseWorkDirPath;
    private File baseWorkDir;
    private static final Monitor M = new Monitor();
    private static final Logger logger = LoggerFactory.getLogger(WorkDirFactory.class);

    public WorkDirFactory() {
    }

    @PostConstruct
    public void postConstruct() {
        this.baseWorkDir = new File(this.baseWorkDirPath);
        if (!this.baseWorkDir.mkdirs() && !this.baseWorkDir.exists()) {
            throw new RuntimeIOException("Couldn't create the base work directory: " + this.baseWorkDirPath);
        }
    }

    public WorkDirFactory(String string) {
        this.baseWorkDirPath = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkDir newWorkDir() {
        OverthereFile overthereFile = LocalFile.valueOf((File)this.baseWorkDir);
        AtomicInteger atomicInteger = new AtomicInteger(1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS");
        String string = "workdir-" + simpleDateFormat.format(new Date());
        String string2 = "";
        String string3 = ".tmp";
        while (atomicInteger.get() < 100) {
            block6: {
                OverthereFile overthereFile2 = overthereFile.getFile(string + string2 + string3);
                M.enter();
                try {
                    if (overthereFile2.exists()) break block6;
                    try {
                        overthereFile2.mkdir();
                    }
                    catch (RuntimeIOException runtimeIOException) {
                        // empty catch block
                    }
                    logger.debug("Created WorkDir {}", (Object)overthereFile2);
                    WorkDir workDir = new WorkDir((LocalFile)overthereFile2);
                    return workDir;
                }
                finally {
                    M.leave();
                }
            }
            string2 = "-" + atomicInteger.getAndIncrement();
        }
        throw new RuntimeIOException("Cannot create WorkDir " + string);
    }
}

