/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.gc;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.service.gc.GarbageCollectionStep;
import com.xebialabs.deployit.task.Task;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jcr.Repository;

public class GarbageCollectionTask
extends Task {
    private static transient AtomicBoolean gcInProgress = new AtomicBoolean(false);

    public GarbageCollectionTask(Repository repository) {
        super(Lists.newArrayList((Object[])new GarbageCollectionStep[]{new GarbageCollectionStep(repository, gcInProgress)}));
    }

    @Override
    public void processAfterRecovery() {
        super.processAfterRecovery();
        gcInProgress = new AtomicBoolean(false);
    }

    @Override
    public void doAfterTaskStateChangedToDone() {
        gcInProgress.set(false);
    }

    @Override
    public void doAfterTaskStateChangedToAborted() {
        gcInProgress.set(false);
    }

    public static boolean isInProgress() {
        return gcInProgress.get();
    }
}

