/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.reader;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.server.api.importer.ImportingContext;
import com.xebialabs.deployit.server.api.util.IdGenerator;
import com.xebialabs.deployit.service.importer.ImporterException;
import com.xebialabs.overthere.local.LocalFile;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployableConfigurationItemReader {
    static final String NAMESPACE_SEPARATOR = "/";
    static final String CI = "CI-";
    static final String TYPE_ATTRIBUTE_NAME = "CI-Type";
    static final String NAME_ATTRIBUTE_NAME = "CI-Name";
    private final Map<String, Attributes> entries;
    private static final Logger logger = LoggerFactory.getLogger(DeployableConfigurationItemReader.class);

    public DeployableConfigurationItemReader(Map<String, Attributes> map) {
        this.entries = map;
    }

    public Deployable readMiddlewareConfiguration(DeploymentPackage deploymentPackage, Map.Entry<String, Attributes> entry) {
        String string = entry.getKey().trim();
        Attributes attributes = entry.getValue();
        String string2 = this.readCIType(attributes, string);
        Descriptor descriptor = this.getDescriptorForConfigurationItem(string, string2);
        Deployable deployable = (Deployable)descriptor.newInstance();
        String string3 = deploymentPackage.getId();
        deployable.setId(string3 + NAMESPACE_SEPARATOR + this.getDeployableNameFromEntryName(string));
        this.fillAttributes(deployable, descriptor, attributes, string3);
        return deployable;
    }

    public boolean isMiddlewareResource(Map.Entry<String, Attributes> entry) {
        String string = entry.getValue().getValue(TYPE_ATTRIBUTE_NAME);
        String string2 = entry.getKey().trim();
        if (DeployableConfigurationItemReader.isBlank(string)) {
            return false;
        }
        Descriptor descriptor = this.getDescriptorForConfigurationItem(string2, string);
        Checks.checkArgument(descriptor.isAssignableTo(Deployable.class), "Configuration item %s of type %s is not Deployable", string2, string);
        return !descriptor.isAssignableTo(DeployableArtifact.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeployableArtifact readArtifact(DeploymentPackage deploymentPackage, ImportSource importSource, Map.Entry<String, Attributes> entry, ImportingContext importingContext) {
        String string = entry.getKey().trim();
        Attributes attributes = entry.getValue();
        String string2 = this.readCIType(attributes, string);
        Descriptor descriptor = this.getDescriptorForConfigurationItem(string, string2);
        DeployableArtifact deployableArtifact = (DeployableArtifact)descriptor.newInstance();
        String string3 = deploymentPackage.getId();
        deployableArtifact.setId(string3 + NAMESPACE_SEPARATOR + this.getDeployableName(string, attributes));
        TFile tFile = new TFile(importSource.getFile());
        try {
            TFile tFile2 = this.createTempFolderForImport(importingContext, (Artifact)deployableArtifact);
            TFile tFile3 = DeployableConfigurationItemReader.copyArtifactData(tFile, string, tFile2, deployableArtifact, string3);
            logger.debug("Adding {} {} to deployment package", (Object)descriptor.getType(), (Object)tFile3);
            deployableArtifact.setFile(LocalFile.valueOf((File)tFile3.getFile()));
            this.fillAttributes((Deployable)deployableArtifact, descriptor, attributes, string3);
            DeployableArtifact deployableArtifact2 = deployableArtifact;
            return deployableArtifact2;
        }
        finally {
            if (tFile.isArchive()) {
                try {
                    TFile.umount((TFile)tFile);
                }
                catch (FsSyncException fsSyncException) {
                    logger.error("Unable to release resources for archive {}", (Object)tFile.getName());
                    logger.error("Following exception occurred while trying to release resources: {}", (Object)fsSyncException.getMessage());
                }
            }
        }
    }

    private static TFile copyArtifactData(TFile tFile, String string, TFile tFile2, DeployableArtifact deployableArtifact, String string2) {
        TFile tFile3 = new TFile((File)tFile, string, TArchiveDetector.NULL);
        if (!tFile3.exists()) {
            throw new RuntimeIOException(String.format("The entry %s could not be found in the importable package %s.", string, string2));
        }
        TFile tFile4 = new TFile((File)tFile2, tFile3.getName());
        try {
            tFile3.cp_r((File)tFile4);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(String.format("Could not copy %s to %s while importing %s", tFile3, tFile4, deployableArtifact.getId()), iOException);
        }
        return tFile4;
    }

    private TFile createTempFolderForImport(ImportingContext importingContext, Artifact artifact) {
        try {
            String string = "temp-" + artifact.getName();
            TFile tFile = new TFile(File.createTempFile(string, "")).rm().mkdir(false);
            ((List)importingContext.getAttribute("temporaryFiles")).add(tFile);
            logger.debug("Created Temporary folder {}", (Object)tFile);
            return tFile;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    private String getDeployableName(String string, Attributes attributes) {
        String string2 = attributes.getValue(NAME_ATTRIBUTE_NAME);
        if (string2 != null) {
            return string2;
        }
        return this.getDeployableNameFromEntryName(string);
    }

    protected String getDeployableNameFromEntryName(String string) {
        String string2;
        int n = string.lastIndexOf(NAMESPACE_SEPARATOR);
        if (n > -1) {
            if (++n >= string.length()) {
                throw new ImporterException("Could not determine artifact Name: %s because entry ends with '/'", string);
            }
            string2 = string.substring(n);
        } else {
            string2 = string;
        }
        return string2;
    }

    private String readCIType(Attributes attributes, String string) {
        String string2 = attributes.getValue(TYPE_ATTRIBUTE_NAME);
        if (DeployableConfigurationItemReader.isBlank(string2)) {
            throw new ImporterException("Could not import Name: %s because of missing %s entry in MANIFEST.MF", string, TYPE_ATTRIBUTE_NAME);
        }
        return string2;
    }

    private Descriptor getDescriptorForConfigurationItem(String string, String string2) {
        Descriptor descriptor = DescriptorRegistry.getDescriptor((String)string2);
        if (descriptor == null) {
            throw new ImporterException("Could not import Name: %s because %s is not a known CI type", string, string2);
        }
        return descriptor;
    }

    private static boolean isBlank(String string) {
        return Strings.nullToEmpty((String)string).trim().isEmpty();
    }

    void fillAttributes(Deployable deployable, Descriptor descriptor, Attributes attributes, String string) {
        block9: for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
            String string2 = propertyDescriptor.getName();
            switch (propertyDescriptor.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    String string3 = attributes.getValue(CI + string2);
                    propertyDescriptor.set((ConfigurationItem)deployable, (Object)string3);
                    continue block9;
                }
                case CI: {
                    String string4 = attributes.getValue(CI + string2);
                    if (string4 == null) continue block9;
                    Deployable deployable2 = this.convertReference(string, string4);
                    propertyDescriptor.set((ConfigurationItem)deployable, (Object)deployable2);
                    continue block9;
                }
                case SET_OF_STRING: {
                    HashSet hashSet = Sets.newHashSet(DeployableConfigurationItemReader.handleCollectionOfStrings(propertyDescriptor, attributes));
                    if (hashSet.isEmpty()) continue block9;
                    propertyDescriptor.set((ConfigurationItem)deployable, (Object)hashSet);
                    continue block9;
                }
                case SET_OF_CI: {
                    HashSet hashSet = Sets.newHashSet(this.transformCollectionOfCis(attributes, string, propertyDescriptor));
                    if (hashSet.isEmpty()) continue block9;
                    propertyDescriptor.set((ConfigurationItem)deployable, (Object)hashSet);
                    continue block9;
                }
                case LIST_OF_STRING: {
                    ArrayList arrayList = Lists.newArrayList(DeployableConfigurationItemReader.handleCollectionOfStrings(propertyDescriptor, attributes));
                    if (arrayList.isEmpty()) continue block9;
                    propertyDescriptor.set((ConfigurationItem)deployable, (Object)arrayList);
                    continue block9;
                }
                case LIST_OF_CI: {
                    ArrayList arrayList = Lists.newArrayList(this.transformCollectionOfCis(attributes, string, propertyDescriptor));
                    if (arrayList.isEmpty()) continue block9;
                    propertyDescriptor.set((ConfigurationItem)deployable, (Object)arrayList);
                    continue block9;
                }
                case MAP_STRING_STRING: {
                    HashMap hashMap = Maps.newHashMap();
                    String string5 = (CI + propertyDescriptor.getName() + "-").toLowerCase();
                    for (Object object : attributes.keySet()) {
                        String string6 = object.toString();
                        if (!string6.toLowerCase().startsWith(string5)) continue;
                        String string7 = string6.substring(string5.length());
                        String string8 = attributes.getValue(string6);
                        hashMap.put(string7, string8);
                    }
                    propertyDescriptor.set((ConfigurationItem)deployable, (Object)hashMap);
                    continue block9;
                }
            }
            throw new IllegalStateException("Should not end up here!");
        }
    }

    private Deployable convertReference(String string, String string2) {
        Attributes attributes = Checks.checkNotNull(this.entries.get(string2), "Couldn't find the referenced entry [%s], are you using the entry Name?", string2);
        Type type = Type.valueOf((String)this.readCIType(attributes, string2));
        Deployable deployable = (Deployable)type.getDescriptor().newInstance();
        String string3 = attributes.getValue(NAME_ATTRIBUTE_NAME);
        if (string3 == null) {
            string3 = string2;
        }
        String string4 = IdGenerator.generateId((String)string, (String)string3);
        deployable.setId(string4);
        return deployable;
    }

    private Collection<Deployable> transformCollectionOfCis(Attributes attributes, final String string, PropertyDescriptor propertyDescriptor) {
        return Collections2.transform(DeployableConfigurationItemReader.handleCollectionOfStrings(propertyDescriptor, attributes), (Function)new Function<String, Deployable>(){

            public Deployable apply(String string2) {
                return DeployableConfigurationItemReader.this.convertReference(string, string2);
            }
        });
    }

    private static Collection<String> handleCollectionOfStrings(PropertyDescriptor propertyDescriptor, Attributes attributes) {
        String string = (CI + propertyDescriptor.getName() + "-EntryValue").toLowerCase();
        String string2 = (CI + propertyDescriptor.getName()).toLowerCase();
        HashSet hashSet = Sets.newHashSet();
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            String string3 = entry.getKey().toString().toLowerCase().trim();
            if (!string3.startsWith(string) && !string3.equals(string2)) continue;
            hashSet.add(entry.getValue().toString());
        }
        return hashSet;
    }
}

