/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.source;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.server.api.importer.ImportSource;
import com.xebialabs.deployit.service.importer.source.FileSource;
import com.xebialabs.deployit.util.GuavaFiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamSource
implements ImportSource {
    private final String fileName;
    private final InputStream stream;
    private FileSource file;
    private final File tempDir;

    public InputStreamSource(String string, InputStream inputStream) {
        this.fileName = string;
        this.stream = inputStream;
        this.tempDir = Files.createTempDir();
    }

    public File getFile() {
        if (this.file == null) {
            this.streamToTempFile();
        }
        return this.file.getFile();
    }

    private void streamToTempFile() {
        try {
            String string = this.fileName;
            int n = string.lastIndexOf(47);
            if (n != -1 && n != string.length() - 1) {
                string = string.substring(n);
            }
            File file = new File(this.tempDir, string);
            ByteStreams.copy((InputStream)this.stream, (OutputSupplier)Files.newOutputStreamSupplier((File)file));
            this.file = new FileSource(file, true);
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    public void cleanUp() {
        if (this.file != null) {
            this.file.cleanUp();
        }
        GuavaFiles.deleteQuietly(this.tempDir);
    }

    public String toString() {
        return this.getClass().getName() + "[" + (this.file != null ? this.file : "no file on disk") + "]";
    }
}

