/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskRegistry;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class ExecutionEngine {
    @Autowired
    private TaskRegistry taskRegistry;
    @Autowired
    private TaskExecutor taskExecutor;
    private static final Logger logger = LoggerFactory.getLogger(ExecutionEngine.class);

    public String register(Task task) {
        Preconditions.checkNotNull((Object)task, (Object)"Should not pass in a null task");
        Authentication authentication = this.getCurrentCredentials();
        task.setOwner(authentication.getName());
        return this.taskRegistry.registerTask(task);
    }

    public Task getTask(String string) {
        return this.taskRegistry.getTask(string);
    }

    private Authentication sanityCheckTask(String string, Task task, String string2) {
        Preconditions.checkState((task != null ? 1 : 0) != 0, (String)"Cannot %s a task that is not registered with id [%s]", (Object[])new Object[]{string2, string});
        Authentication authentication = this.getCurrentCredentials();
        if (!authentication.getName().equals(task.getOwner())) {
            throw new PermissionDeniedException(String.format("Cannot %s a task registered by another user", string2));
        }
        return authentication;
    }

    protected Authentication getCurrentCredentials() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Preconditions.checkNotNull((Object)authentication, (Object)"No authentication present, are you logged in?");
        return authentication;
    }

    public void execute(String string) {
        Task task = this.taskRegistry.getTask(string);
        Authentication authentication = this.sanityCheckTask(string, task, "start");
        this.setCredentialsIfNotPresent(task, authentication);
        task.performPreFlightChecks();
        FutureTask<Object> futureTask = new FutureTask<Object>(task, null);
        task.setWrappingTask(futureTask);
        task.setState(Task.State.QUEUED);
        this.taskExecutor.execute(futureTask);
    }

    private void setCredentialsIfNotPresent(Task task, Authentication authentication) {
        if (task.getOwnerCredentials() == null) {
            task.setOwnerCredentials(authentication);
        }
    }

    public void stopExecution(String string) {
        Task task = this.taskRegistry.getTask(string);
        Authentication authentication = this.sanityCheckTask(string, task, "stop");
        this.setCredentialsIfNotPresent(task, authentication);
        task.stop();
    }

    public void abortExecution(String string) {
        Task task = this.taskRegistry.getTask(string);
        Authentication authentication = this.sanityCheckTask(string, task, "abort");
        this.setCredentialsIfNotPresent(task, authentication);
        task.abort();
    }

    public void cancel(String string) {
        Task task = this.taskRegistry.getTask(string);
        Authentication authentication = this.sanityCheckTask(string, task, "cancel");
        this.setCredentialsIfNotPresent(task, authentication);
        this.taskRegistry.cancelTask(string);
    }

    public List<Task> getAllIncompleteTasksForCurrentUser() {
        return this.taskRegistry.getIncompleteTasksForUser(this.getCurrentCredentials().getName());
    }

    public List<Task> getAllIncompleteTasks() {
        return this.taskRegistry.getAllIncompleteTasks();
    }

    @PreDestroy
    public void shutdownTasks() {
        this.requestStopOnTasks();
        this.waitForTasksToBeStopped();
        this.taskRegistry.destroy();
    }

    private void waitForTasksToBeStopped() {
        for (Task task : this.taskRegistry.getTasks()) {
            if (!task.isExecuting()) continue;
            try {
                logger.info("Waiting for task {} to stop", (Object)task.getId());
                FutureTask<Object> futureTask = task.getWrappingTask();
                if (futureTask == null) continue;
                futureTask.get();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                logger.error("Could not wait for task {} to be stopped...", (Object)task.getId());
            }
        }
    }

    private void requestStopOnTasks() {
        for (Task task : this.taskRegistry.getTasks()) {
            if (!task.isExecuting()) continue;
            task.stop();
        }
    }
}

